package com.liquidnet.service.goblin.test;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.galaxy.dto.bo.GalaxySeriesNftInfoBo;
import com.liquidnet.service.galaxy.utils.GalaxyDataUtils;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;

@Slf4j
@RunWith(SpringJUnit4ClassRunner.class)
//@ActiveProfiles("test")
@SpringBootTest
public class TestGoblinMongo {
    @Autowired
    private MongoTemplate mongoTemplate;

    @Autowired
    private GalaxyDataUtils galaxyDataUtils;

    @SneakyThrows
    @Test
    public void testMongoUpdateLocalDateTime() {
        ObjectWriter om = JsonUtils.OM().writerWithDefaultPrettyPrinter();

        LocalDateTime now = LocalDateTime.now();
        Object nowTimeMdbObj = mongoTemplate.getConverter().convertToMongoType(now);
        Date from = Date.from(now.atZone(ZoneId.systemDefault()).toInstant());
        log.info("now:{},mdbObj:{},from:{}", now, nowTimeMdbObj, from);

//        GoblinGoodsSkuInfoVo findRstVo = mongoTemplate.findOne(Query.query(Criteria.where("delFlg").is("0").and("deletedAt").is("2022-04-18T04:33:12.443+00:00")), GoblinGoodsSkuInfoVo.class, GoblinGoodsSkuInfoVo.class.getSimpleName());
//        log.info("MDB.findOne:{}", om.writeValueAsString(findRstVo));

//        LocalDateTime now = LocalDateTime.now();
//        Object nowObj = mongoTemplate.getConverter().convertToMongoType(now);
//        UpdateResult updateResult = mongoTemplate.getCollection(GoblinGoodsSkuInfoVo.class.getSimpleName()).updateOne(
//                Query.query(Criteria.where("skuId").is(findRstVo.getSkuId())).getQueryObject(),
//                Update.update("deletedAt", nowObj).set("deletedBy", "local.test").set("updatedAt", now).set("updatedBy", "local.test").getUpdateObject()
//        );
//        log.info("MDB.getCollection(...).updateOne:{}", JsonUtils.toJson(updateResult));
//
//        findRstVo = mongoTemplate.findOne(Query.query(Criteria.where("delFlg").is("0")), GoblinGoodsSkuInfoVo.class, GoblinGoodsSkuInfoVo.class.getSimpleName());
//        log.info("MDB.findOne:{}", om.writeValueAsString(findRstVo));
    }

    @Test
    public void testUpdate(){
        String skuId = "1234567890-sku-0225";
        Query query = Query.query(Criteria.where("skuId").is(skuId));
        GalaxySeriesNftInfoBo seriesNftInfoBo = galaxyDataUtils.getSeriesNftInfoBo("zxinchain",skuId);
        log.info(seriesNftInfoBo.toString());

        //1、插入时间正确 为UTC时间
        seriesNftInfoBo.setSkuId("1234567890-sku-0226");
        seriesNftInfoBo.setCreatedAt(LocalDateTime.now());
        seriesNftInfoBo.setUpdatedAt(LocalDateTime.now());
//        Document document = (Document)mongoTemplate.convertToMongoType(seriesNftInfoBo);
//        mongoTemplate.getCollection(GalaxySeriesNftInfoVo2.class.getSimpleName()).insertOne(document);

        //2、插入时间正确
//         UpdateResult result = mongoTemplate.updateMulti(
//                 query,
//                 Update.update("nftName", "正在映画NFT名字003").set("updatedAt", LocalDateTime.now()),
//                 GalaxySeriesNftInfoVo2.class.getSimpleName()
//         );

        //3、插入时间正确 为UTC时间
//        seriesNftInfoBo.setUpdatedAt(LocalDateTime.now());
//        BasicDBObject basicDBObject = new BasicDBObject();
//        UpdateResult result = mongoTemplate.getCollection(GalaxySeriesNftInfoVo2.class.getSimpleName()).updateOne(
//                query.getQueryObject(),
//                basicDBObject.append("$set", mongoConverter.convertToMongoType(seriesNftInfoBo))
//        );

        //4、时间插入正确
//        BasicDBObject basicDBObject = new BasicDBObject();
//        seriesNftInfoBo.setUpdatedAt(LocalDateTime.now());
//        Document result = mongoTemplate.getCollection(GalaxySeriesNftInfoVo2.class.getSimpleName()).findOneAndUpdate(
//                query.getQueryObject(),
//                basicDBObject.append("$set", mongoConverter.convertToMongoType(seriesNftInfoBo)),
//                new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
//        );
//        log.info("updateSeriesNftCrtCount result:{}", result.toString());

        //5、插入时间正确 为UTC时间
        //注意：使用mongoConverter.convertToMongoType转换时 update.set不生效
//        seriesNftInfoBo.setUpdatedAt(LocalDateTime.now());
//        Document document = (Document)mongoConverter.convertToMongoType(seriesNftInfoBo);
//        Update update = Update.fromDocument(document);
//        update.set("updatedAt",LocalDateTime.now());//
//        UpdateResult result = mongoTemplate.updateFirst(query,update, GalaxySeriesNftInfoVo2.class,GalaxySeriesNftInfoVo2.class.getSimpleName());


        //6、插入时间正确 插入为非UTC时间 2022-04-14T17:03:23.269
//        seriesNftInfoBo.setUpdatedAt(LocalDateTime.now());
//        BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(seriesNftInfoBo)));
//        mongoTemplate.getCollection(GalaxySeriesNftInfoVo2.class.getSimpleName()).updateOne(
//                query.getQueryObject(),
//                orderObject
//        );

        //7、时间插入正确 为UTC
//        HashMap<String, Object> map = new HashMap<>();
//        map.put("nftName", "正在映画NFT名字002");
//        map.put("updatedAt", LocalDateTime.now());
//        UpdateResult result = mongoTemplate.getCollection(GalaxySeriesNftInfoVo2.class.getSimpleName()).updateOne(
//                query.getQueryObject(),
//                new BasicDBObject("$set", mongoConverter.convertToMongoType(map))
//                );
//        log.info("updateSeriesNftCrtCount result:{}",result.toString());

        //8、时间插入正确 为UTC
//        HashMap<String, Object> map = new HashMap<>();
//        map.put("nftName", "正在映画NFT名字003");
//        map.put("updatedAt", LocalDateTime.now());
//        UpdateResult result = mongoTemplate.getCollection(GalaxySeriesNftInfoVo2.class.getSimpleName()).updateOne(
//                query.getQueryObject(),
//                new Document("$set", mongoConverter.convertToMongoType(map))
//        );
//        log.info("updateSeriesNftCrtCount result:{}",result.toString());

        //1、时间插入错误
        // 把当前时间强制转换为了UTC时间  直接在时间后加'Z' 2022-04-14T07:19:35.374Z
//        UpdateResult result = mongoTemplate.getCollection(GalaxySeriesNftInfoVo2.class.getSimpleName()).updateOne(
//                query.getQueryObject(),
//                new Document("$set", new Document("updatedAt", LocalDateTime.now()).append("nftName", "正在映画NFT名字002"))
//                );
//        log.info("updateSeriesNftCrtCount result:{}",result.toString());


        //2、时间插入错误
        // 把当前时间强制转换为了UTC时间  直接在时间后加'Z' 2022-04-14T07:19:35.374Z
//        UpdateResult result = mongoTemplate.getCollection(GalaxySeriesNftInfoVo2.class.getSimpleName()).updateOne(
//                query.getQueryObject(),
//                Update.update("nftName", "正在映画NFT名字001").set("updatedAt", LocalDateTime.now()).getUpdateObject());
//        log.info("updateSeriesNftCrtCount result:{}",result.toString());

        //3、插入时间错误
        //把当前时间强制转换为了UTC时间  直接在时间后加'Z' 2022-04-14T07:19:35.374Z
//        UpdateResult result = mongoTemplate.getCollection(GalaxySeriesNftInfoVo2.class.getSimpleName()).updateMany(
//            query.getQueryObject(),
//            Update.update("nftName", "正在映画NFT名字001").set("updatedAt", LocalDateTime.now()).getUpdateObject());
//        log.info("updateSeriesNftCrtCount result:{}",result.toString());

        //4、时间插入错误
        // 把当前时间强制转换为了UTC时间  直接在时间后加'Z' 2022-04-14T07:19:35.374Z
//        seriesNftInfoBo.setUpdatedAt(LocalDateTime.now());
//        Document result = mongoTemplate.getCollection(GalaxySeriesNftInfoVo2.class.getSimpleName()).findOneAndUpdate(
//                query.getQueryObject(),
//                Update.update("nftName", "正在映画NFT名字001").set("updatedAt", LocalDateTime.now()).getUpdateObject(),
//                new FindOneAndUpdateOptions().returnDocument(ReturnDocument.AFTER)
//        );
//        log.info("updateSeriesNftCrtCount result:{}", result.toString());

        //5、插入时间未知，执行报错
//        seriesNftInfoBo.setUpdatedAt(LocalDateTime.now());
//        Update update = Update.fromDocument(Document.parse(JsonUtils.toJson(seriesNftInfoBo)));
//        UpdateResult result = mongoTemplate.getCollection(GalaxySeriesNftInfoVo2.class.getSimpleName()).updateMany(
//                query.getQueryObject(),
//                update.getUpdateObject());
//        log.info("updateSeriesNftCrtCount result:{}",result.toString());

        //6、时间插入错误
        // 把当前时间强制转换为了UTC时间  直接在时间后加'Z' 2022-04-14T07:19:35.374Z
//        HashMap<String, Object> map = new HashMap<>();
//        map.put("nftName", "正在映画NFT名字002");
//        map.put("updatedAt", LocalDateTime.now());
//        UpdateResult result = mongoTemplate.getCollection(GalaxySeriesNftInfoVo2.class.getSimpleName()).updateOne(
//                query.getQueryObject(),
//                new BasicDBObject("$set", map)
//                );
//        log.info("updateSeriesNftCrtCount result:{}",result.toString());

    }
}
