package com.liquidnet.service.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.commons.lang.util.IdentityUtils;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.commons.lang.util.StringUtil;
import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.goblin.dto.vo.SmileSchoolVo;
import com.liquidnet.service.goblin.dto.vo.SmileUserVO;
import com.liquidnet.service.goblin.service.manage.SmileFrontService;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author zhangfuxin
 * @Description:用户接口
 * @date 2021/12/27 下午6:25
 */
@Api(tags = "前端接口管理(需要登陆状态)")
@RestController
@RequestMapping("/front")
@Slf4j
public class SmileUserController {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private SmileFrontService smileFrontService;

    @GetMapping("getUser")
    @ApiOperation("获取用户状态，如果没查到，则返回null")
    public ResponseDto<SmileUserVO> getUser() {
        String userId = CurrentUtil.getCurrentUid();
        SmileUserVO smileUserVO= (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
        return ResponseDto.success(smileUserVO);
    }
    @GetMapping("getSchool")
    @ApiOperation("获得学校")
    public ResponseDto<List<SmileSchoolVo>> getSchool() {
        String userId = CurrentUtil.getCurrentUid();
        List<SmileSchoolVo> list=null;
        if(redisUtil.hasKey(SmileRedisConst.SMILE_SCHOOL.concat(userId))){
            list= (List<SmileSchoolVo>) redisUtil.get(SmileRedisConst.SMILE_SCHOOL.concat(userId));
        }
        return ResponseDto.success(list);
    }
    @GetMapping("getPerformance")
    @ApiOperation("获得演出列表")
    public ResponseDto<List<KylinPerformanceVo>> getPerformance() {
        return ResponseDto.success(smileFrontService.getPerformance());
    }
    @GetMapping("repeatAuth")
    @ApiOperation("重新认证")
    public ResponseDto<List<KylinPerformanceVo>> repeatAuth() {
        String userId = CurrentUtil.getCurrentUid();
        redisUtil.del(SmileRedisConst.SMILE_USER.concat(userId));
        return ResponseDto.success(smileFrontService.getPerformance());
    }
    @GetMapping("auth")
    @ApiOperation("认证")
    public ResponseDto auth() {
        String userId = CurrentUtil.getCurrentUid();
        SmileUserVO smileUserVORedis= (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
        return ResponseDto.success(smileFrontService.auth(userId,smileUserVORedis));
    }


    //
    @PostMapping("saveOrUpdateUserOneStep")
    @ApiOperation("增加或者删除第一步")
    public ResponseDto saveOrUpdateUserOneStep(@RequestBody SmileUserVO smileUserVO) {
        String userId = CurrentUtil.getCurrentUid();
        SmileUserVO smileUserVORedis= (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
        smileUserVO.setUid(userId);
        if(null==smileUserVORedis){
            smileUserVO.setTag("1");
        }else{
            smileUserVO.setTag(smileUserVORedis.getTag().concat(",1"));
        }
        smileFrontService.saveOrUpdateUser(smileUserVO,smileUserVORedis,"1");
        return  ResponseDto.success();
    }

    @PostMapping("saveOrUpdateUserTwoStep")
    @ApiOperation("增加或者删除第二步")
    public ResponseDto saveOrUpdateUserTwoStep(@RequestBody SmileUserVO smileUserVO) {
        if(StringUtil.isNotBlank(smileUserVO.getIdCard())&&StringUtil.isNotBlank(smileUserVO.getName())){
            String userId = CurrentUtil.getCurrentUid();
            if(validate(smileUserVO.getName(),smileUserVO.getIdCard())){
                smileUserVO.setUid(userId);
                SmileUserVO smileUserVORedis= (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
                if(null==smileUserVORedis){
                    smileUserVORedis.setTag("2");
                }else{
                    if(smileUserVORedis.getTag().contains("2")){
                        ResponseDto.success(null);
                    }else{
                        smileUserVO.setTag(smileUserVORedis.getTag().concat(",2"));
                    }
                }
                smileFrontService.saveOrUpdateUser(smileUserVO,smileUserVORedis,"2");
            }else {
                return  ResponseDto.failure("验证身份证失败！");
            }

        }

        return  ResponseDto.success();
    }
    public boolean validate(String realName,String cardNo){
        String respStr = IdentityUtils.aliThird(realName, cardNo), respErrorCode = null;
        JsonNode respJNode = JsonUtils.fromJson(respStr, JsonNode.class);
        if (null == respJNode || !"0".equals(respErrorCode = String.valueOf(respJNode.get("error_code")))) {
            log.info("###实名认证失败[{}]", respJNode);
            ErrorMapping.ErrorMessage errorMessage = ErrorMapping.get("10102");
            return false;
        }
        return true;
    }
    @PostMapping("saveOrUpdateUserThreeStep")
    @ApiOperation("增加或者删除第三步")
    public ResponseDto saveOrUpdateUserThreeStep(@RequestBody SmileUserVO smileUserVO) {
        String userId = CurrentUtil.getCurrentUid();
        smileUserVO.setUid(userId);
        SmileUserVO smileUserVORedis= (SmileUserVO) redisUtil.get(SmileRedisConst.SMILE_USER.concat(userId));
        if(null==smileUserVORedis){
            smileUserVORedis.setTag("3");
        }else{
            if(smileUserVORedis.getTag().contains("3")){
            }else{
                smileUserVO.setTag(smileUserVORedis.getTag().concat(",3"));
            }
        }
        smileFrontService.saveOrUpdateUser(smileUserVO,smileUserVORedis,"3");
        return  ResponseDto.success();
    }



}
