package com.liquidnet.client.admin.zhengzai.adam.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.common.core.text.Convert;
import com.liquidnet.client.admin.zhengzai.adam.service.IAdamUserService;
import com.liquidnet.service.adam.entity.AdamUser;
import com.liquidnet.service.adam.mapper.AdamUserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 用户Service业务层处理
 * 
 * @author ruoyi
 * @date 2021-05-24
 */
@Service
public class AdamUserServiceImpl extends ServiceImpl<AdamUserMapper, AdamUser>  implements IAdamUserService
{
    @Autowired
    private AdamUserMapper adamUserMapper;

    /**
     * 查询用户
     *
     * @param mid 用户ID
     * @return 用户
     */
    @Override
    public AdamUser selectAdamUserById(Integer mid)
    {
        return adamUserMapper.selectById(mid);
    }

    /**
     * 查询用户列表
     *
     * @param adamUser 用户
     * @return 用户
     */
    @Override
    public List<AdamUser> selectAdamUserList(AdamUser adamUser)
    {
        return adamUserMapper.selectList(null);
    }

    /**
     * 新增用户
     *
     * @param adamUser 用户
     * @return 结果
     */
    @Override
    public int insertAdamUser(AdamUser adamUser)
    {
        return adamUserMapper.insert(adamUser);
    }

    /**
     * 修改用户
     *
     * @param adamUser 用户
     * @return 结果
     */
    @Override
    public int updateAdamUser(AdamUser adamUser)
    {
        return adamUserMapper.updateById(adamUser);
    }

    /**
     * 删除用户对象
     *
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteAdamUserByIds(String ids)
    {
        return adamUserMapper.deleteById(Convert.toStrArray(ids));
    }

    /**
     * 删除用户信息
     *
     * @param mid 用户ID
     * @return 结果
     */
    @Override
    public int deleteAdamUserById(Integer mid)
    {
        return adamUserMapper.deleteById(mid);
    }
}
