package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetArtists;
import com.liquidnet.service.sweet.entity.SweetManualNotify;
import com.liquidnet.service.sweet.mapper.SweetManualNotifyMapper;
import com.liquidnet.service.sweet.service.ISweetManualNotifyService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 电子宣传手册通知表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Service
public class SweetManualNotifyServiceImpl extends ServiceImpl<SweetManualNotifyMapper, SweetManualNotify> implements ISweetManualNotifyService {

    @Autowired
    private SweetManualNotifyMapper sweetManualNotifyMapper;

    @Override
    public ResponseDto<PageInfo<SweetManualNotify>> getList(Integer page, Integer size, String title,String manualId) {
        PageInfo<SweetManualNotify> pageInfo = null;
        try {
            PageHelper.startPage(page, size);
            List<SweetManualNotify> data = sweetManualNotifyMapper.selectList(Wrappers.lambdaQuery(SweetManualNotify.class).like(SweetManualNotify::getTitle, title).eq(SweetManualNotify::getManualId,manualId).eq(SweetManualNotify::getStatus, 1));
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        } catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }
    }

    @Override
    public ResponseDto<Boolean> add(String manualId,String title, String content) {
        try {
            SweetManualNotify sweetManualNotify = new SweetManualNotify();
            sweetManualNotify.setManualNotifyId(IDGenerator.nextSnowId());
            sweetManualNotify.setManualId(manualId);
            sweetManualNotify.setTitle(title);
            sweetManualNotify.setContent(content);
            sweetManualNotify.setCreatedAt(LocalDateTime.now());
            sweetManualNotifyMapper.insert(sweetManualNotify);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<SweetManualNotify> details(String manualId) {
        try {
            return ResponseDto.success(sweetManualNotifyMapper.selectOne(Wrappers.lambdaQuery(SweetManualNotify.class).eq(SweetManualNotify::getManualId, manualId).eq(SweetManualNotify::getStatus, 1)));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> change(String manualId, String title, String content) {
        try {
            SweetManualNotify sweetManualNotify = new SweetManualNotify();
            sweetManualNotify.setTitle(title);
            sweetManualNotify.setContent(content);
            sweetManualNotify.setUpdatedAt(LocalDateTime.now());
            sweetManualNotifyMapper.update(sweetManualNotify, Wrappers.lambdaUpdate(SweetManualNotify.class).eq(SweetManualNotify::getManualId, manualId));
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> delete(String manualNotifyId) {
        try {
            SweetManualNotify sweetManualNotify = new SweetManualNotify();
            sweetManualNotify.setStatus(0);
            sweetManualNotify.setUpdatedAt(LocalDateTime.now());
            sweetManualNotifyMapper.update(sweetManualNotify, Wrappers.lambdaUpdate(SweetManualNotify.class).eq(SweetManualNotify::getManualNotifyId, manualNotifyId));
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }
}
