package com.liquidnet.service.sweet.utils;

import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.liquidnet.common.cache.redis.util.RedisUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.sweet.constant.SweetConstant;
import com.liquidnet.service.sweet.dto.SweetManualAppletDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistList2Dto;
import com.liquidnet.service.sweet.dto.SweetManualArtistListDto;
import com.liquidnet.service.sweet.dto.SweetManualArtistStageListDto;
import com.liquidnet.service.sweet.entity.SweetManualNotify;
import com.liquidnet.service.sweet.entity.SweetManualSort;
import com.liquidnet.service.sweet.entity.SweetRichtext;
import com.liquidnet.service.sweet.mapper.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@Component
public class RedisDataUtils {

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private SweetManualMapper sweetManualMapper;
    @Autowired
    private SweetManualArtistsMapper sweetManualArtistsMapper;
    @Autowired
    private SweetRichtextMapper sweetRichtextMapper;
    @Autowired
    private SweetManualSortMapper sweetManualSortMapper;
    @Autowired
    private SweetManualNotifyMapper sweetManualNotifyMapper;


    public List<SweetManualAppletDto> setPushList() {
        String redisKey = "";
        List<SweetManualAppletDto> data = sweetManualMapper.getManualAppletDto();
        for (SweetManualAppletDto item : data) {
            item.setFieldName((String) redisUtil.hget("kylin:fields:id" + ":" + item.getFieldId(), "name"));
            item.setLatitude((String) redisUtil.hget("kylin:fields:id" + ":" + item.getFieldId(), "latitude"));
            item.setLongitude((String) redisUtil.hget("kylin:fields:id" + ":" + item.getFieldId(), "longitude"));
        }
        redisUtil.set(redisKey, data);
        return data;
    }

    public List<SweetManualAppletDto> getPushList() {
        String redisKey = "";
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setPushList();
        } else {
            return (List<SweetManualAppletDto>) obj;
        }
    }

    public SweetManualAppletDto getAppletPerformance(String manualId) {
        List<SweetManualAppletDto> data = getPushList();
        SweetManualAppletDto returnData = new SweetManualAppletDto();
        for (SweetManualAppletDto item : data) {
            if (item.getManualId().equalsIgnoreCase(manualId)) {
                returnData = item;
                break;
            }
        }
        return returnData;
    }

    public SweetManualArtistList2Dto setTimeList(String manualId, String dateTime) {
        String redisKey = "".concat(manualId).concat(dateTime);
        HashMap<String, Object> map = new HashMap<>();
        map.put("manualId", manualId);
        List<SweetManualArtistListDto> data = sweetManualArtistsMapper.getManualList(map);

        //获取时间
        SweetManualAppletDto sweetManualAppletDto = getAppletPerformance(manualId);
        int intervalDay = (int) DateUtil.intervalDays(DateUtil.parse(sweetManualAppletDto.getTimeStart(), "yyyyMMdd"), (DateUtil.parse(sweetManualAppletDto.getTimeEnd(), "yyyyMMdd")));
        Date timeStartDate = DateUtil.parse(sweetManualAppletDto.getTimeStart(), "yyyyMMdd");
        ArrayList<String> list = new ArrayList<>();
        list.add(DateUtil.format(timeStartDate, DateUtil.Formatter.yyyy_MM_dd));
        for (int i = 0; i < intervalDay; i++) {
            list.add(DateUtil.format(DateUtil.addDay(timeStartDate, 1), DateUtil.Formatter.yyyy_MM_dd));
        }

        //获取舞台
        List<SweetManualArtistStageListDto> stageData = sweetManualArtistsMapper.getStageNameList(map);

        SweetManualArtistList2Dto returnData = new SweetManualArtistList2Dto();
        returnData.setDate(list);
        returnData.setData(data);
        returnData.setStage(stageData);
        redisUtil.set(redisKey, returnData);
        return returnData;
    }

    public SweetManualArtistList2Dto getTimeList(String manualId, String dateTime) {
        String redisKey = "".concat(manualId).concat(dateTime);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setTimeList(manualId, dateTime);
        } else {
            return (SweetManualArtistList2Dto) obj;
        }
    }

    public SweetRichtext setRichTextRedisData(String manualId, String type) {
        String redisKey = "".concat(manualId).concat(type);
        SweetRichtext sweetRichtext = sweetRichtextMapper.selectOne(Wrappers.lambdaQuery(SweetRichtext.class).eq(SweetRichtext::getManualId, manualId).eq(SweetRichtext::getType, type));
        redisUtil.set(redisKey, sweetRichtext);
        return sweetRichtext;
    }

    public SweetRichtext getRichTextRedisData(String manualId, String type) {
        String redisKey = "".concat(manualId).concat(type);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setRichTextRedisData(manualId, type);
        } else {
            return (SweetRichtext) obj;
        }
    }

    public List<String> setTagRedisData(String manualId) {
        String redisKey = "".concat(manualId);
        SweetManualSort data = sweetManualSortMapper.selectOne(Wrappers.lambdaQuery(SweetManualSort.class).eq(SweetManualSort::getManualId, manualId));
        String[] arrays = data.getShowPosition().split(",");
        List<String> returnData = new ArrayList<>();
        for (String item : arrays) {
            returnData.add(SweetConstant.ManualPosition.valueOf(item).getMessage());
        }
        redisUtil.set(redisKey, returnData);
        return returnData;
    }

    public List<String> getTagRedisData(String manualId) {
        String redisKey = "".concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setTagRedisData(manualId);
        } else {
            return (List<String>) obj;
        }
    }

    public List<SweetManualNotify> setNotifyRedisData(String manualId) {
        String redisKey = "".concat(manualId);
        List<SweetManualNotify> data = sweetManualNotifyMapper.selectList(Wrappers.lambdaQuery(SweetManualNotify.class).eq(SweetManualNotify::getManualId, manualId).eq(SweetManualNotify::getStatus, 1));
        redisUtil.set(redisKey, data);
        return data;
    }

    public List<SweetManualNotify> getNotifyRedisData(String manualId) {
        String redisKey = "".concat(manualId);
        Object obj = redisUtil.get(redisKey);
        if (obj == null) {
            return setNotifyRedisData(manualId);
        } else {
            return (List<SweetManualNotify>) obj;
        }
    }
    
}
