package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel
@Data
public class GoblinStoreOrderListVo implements Cloneable {
    @ApiModelProperty(value = "订单id")
    private String orderId;
    @ApiModelProperty(value = "订单号")
    private String orderCode;
    @ApiModelProperty(value = "下单时间")
    private String createdAt;
    @ApiModelProperty(value = "下单方式")
    private String payType;
    @ApiModelProperty(value = " 收货人姓名")
    private String expressContacts;
    @ApiModelProperty(value = " 收货人联系方式")
    private String expressPhone;
    @ApiModelProperty(value = " 收货人地址")
    private String expressAddressDetail;
    @ApiModelProperty(value = " 收货人省市县")
    private String expressAddress;
    @ApiModelProperty(value = " 付款金额")
    private BigDecimal priceActual;
    @ApiModelProperty(value = " 快递费")
    private BigDecimal priceExpress;
    @ApiModelProperty(value = " 订单状态")
    private Integer status;
    @ApiModelProperty(value = " 付款时间")
    private String payTime;
    @ApiModelProperty(value = " 物流公司姓名")
    private String logisticsCompany;
    //todo 胡佳晨 缺发货时间
    @ApiModelProperty(value = " sku相关")
    private List<GoblinStoreOrderListSkuVo> storeOrderListSkuVoList;



    private static final GoblinStoreOrderListVo obj = new GoblinStoreOrderListVo();

    public static GoblinStoreOrderListVo getNew() {
        try {
            return (GoblinStoreOrderListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreOrderListVo();
        }
    }
}
