package com.liquidnet.service.goblin.controller;

import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.codec.vo.EncryptedReq;
import com.liquidnet.service.goblin.dto.manage.GoblinOrderParam;
import com.liquidnet.service.goblin.dto.vo.*;
import com.liquidnet.service.goblin.param.GoblinAppOrderRefundParam;
import com.liquidnet.service.goblin.param.PayAgainParam;
import com.liquidnet.service.goblin.param.SyncOrderParam;
import com.liquidnet.service.goblin.service.IGoblinOrderAppService;
import com.liquidnet.service.goblin.service.IGoblinOrderService;
import io.swagger.annotations.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.List;

@Slf4j
@Api(tags = "订单相关-App")
@RestController
@RequestMapping("/order")
public class GoblinOrderAppController {

    @Autowired
    IGoblinOrderAppService goblinOrderAppService;

    @PostMapping("list")
    @ApiOperation("列表")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "page", value = "页数", example = "1"),
            @ApiImplicitParam(type = "form", required = false, dataType = "String", name = "pre", value = "活动前缀[ZZ-正在下单|不传为普通订单]", example = "ZZ"),
    })
    public ResponseDto<PageInfo<GoblinAppOrderListVo>> orderList(@RequestParam("page") @Valid int page,
                                                                 @RequestParam(value = "pre", required = false) String pre) {
        return goblinOrderAppService.orderList(page, pre);
    }

    @PostMapping("listByCode")
    @ApiOperation("列表[根据masterCode]")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderMasterCode", value = "主订单号"),
    })
    public ResponseDto<List<GoblinAppOrderListVo>> orderListByMaster(@RequestParam("orderMasterCode") @Valid String orderMasterCode) {
        return goblinOrderAppService.orderListByMaster(orderMasterCode);
    }

    @PostMapping("details")
    @ApiOperation("详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id", example = "1"),
    })
    public ResponseDto<GoblinAppOrderDetailsVo> orderDetails(@RequestParam("orderId") @Valid String orderId) {
        String uid = CurrentUtil.getCurrentUid();
        return goblinOrderAppService.orderDetails(orderId, uid);
    }

    @PostMapping("getProduce")
    @ApiOperation("已收货")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id", example = "1"),
    })
    public ResponseDto<Boolean> getProduce(@RequestParam("orderId") @Valid String orderId) {
        String uid = CurrentUtil.getCurrentUid();
        return goblinOrderAppService.getProduce(orderId, uid);
    }

    @PostMapping("applyRefund")
    @ApiOperation("退款申请")
    public ResponseDto<Boolean> applyRefund(@RequestBody GoblinAppOrderRefundParam param) {
        return goblinOrderAppService.applyRefund(param);
    }

    @PostMapping("refundDetails")
    @ApiOperation("退款详情")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "orderId", value = "订单id", example = "1"),
    })
    public ResponseDto<List<GoblinBackOrderVo>> refundDetails(@RequestParam("orderId") @Valid String orderId) {
        return goblinOrderAppService.refundDetails(orderId);
    }
}
