package com.liquidnet.client.admin.zhengzai.kylin.utils;

import com.liquidnet.common.cache.redis.util.RedisDataSourceUtil;
import com.liquidnet.commons.lang.util.CollectionUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.stereotype.Component;

import java.util.HashMap;

@Component
public class QueueUtils {

    @Autowired
    RedisDataSourceUtil redisDataSourceUtil;

    /**
     * 发送消息 - REDIS
     *
     * @param streamKey Redis消费Key
     * @param jsonMsg   Json字符串
     */
    public void sendMsgByRedis(String streamKey, String jsonMsg) {
        HashMap<String, String> map = CollectionUtil.mapStringString();
        map.put("message", jsonMsg);
        redisDataSourceUtil.getRedisKylinUtil().getStringRedisTemplate().opsForStream().add(StreamRecords.mapBacked(map).withStreamKey(streamKey));
    }
}
