use dev_ln_scene;
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_service_support;
create table goblin_service_support
(
    mid        bigint auto_increment primary key,
    ssid       varchar(30)  not null comment '服务支持id',
    name       varchar(50)  not null comment '服务支持名称',
    `desc`     varchar(256) null comment '服务支持描述',
    url        varchar(256) null comment '服务支持的图片地址',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    created_by varchar(64)  not null,
    created_at datetime     not null,
    updated_by varchar(64)  null,
    updated_at datetime     null,
    deleted_by varchar(64)  null,
    deleted_at datetime     null,
    comment    varchar(500)
) engine = InnoDB comment '服务支持';

create unique index uidx_gss_service_support_id on goblin_service_support (ssid);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_self_tag;
create table goblin_self_tag
(
    mid        bigint auto_increment primary key,
    tag_id     varchar(30)  not null comment '标签id',
    tag_name   varchar(50)  not null comment '标签名称',
    tag_desc   varchar(128) null comment '标签描述',
    tag_pic    varchar(256) null comment '标签图片',
    tag_type   char         null comment '标签类型[0-商品标签|1-音乐人|2-艺术家|3-品牌方|4-厂牌|5-AR]',
    tag_belong char default '0' comment '标签所属[0-普通标签|1-专属标签]',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    counts     int  default 0 comment '关联商品计数',
    comment    varchar(255)
) engine = InnoDB comment '平台标签库';

create unique index uidx_gst_tag_id on goblin_self_tag (tag_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_self_goods_category;
create table goblin_self_goods_category
(
    mid        bigint auto_increment primary key,
    cate_id    varchar(30) not null comment '商铺分类id',
    name       varchar(50) not null comment '分类名称',
    icon       varchar(256) null comment '分类图标',
    sort       int  default 0 comment '排序[数值越小,排序越前]',
    grade      char        null comment '分类层级[1-一级|2-二级|3-三级]',
    cate_pid   varchar(30) null comment '分类父id',
    ne_isbn    char default '0' comment '是否需要填写ISBN[0-否|1-是]',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    counts     int  default 0 comment '关联商品计数',
    created_by varchar(64) not null,
    created_at datetime    not null,
    updated_by varchar(64) null,
    updated_at datetime    null,
    deleted_by varchar(64) null,
    deleted_at datetime    null,
    comment    varchar(255)
) engine = InnoDB comment '平台商品分类';

create unique index uidx_gsgc_cate_id on goblin_self_goods_category (cate_id);
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_store_info;
create table goblin_store_info
(
    mid            bigint auto_increment primary key,
    store_id       varchar(64)  not null comment '店铺id',
    uid            varchar(64)  not null comment '店主UID',
    store_name     varchar(128) null comment '店铺名称',
    logo_pic       varchar(256) null comment '店铺LOGO',
    background_pic varchar(256) null comment '店铺背景图',
    introduce      varchar(500) null comment '店铺介绍',
    status         char          default '0' comment '店铺状态[0-填写资料中|1-店铺审核中|2-审核不通过|3-审核通过|4-停业|5-营业]',
    reason         varchar(256) null comment '拒绝原因',
    store_type     char          default '1' comment '店铺类型[1-普通店铺|2-加盟|3-连锁|5-直营]',
    cert_type      char         not null comment '认证类型[1-企业/公司|2-个体工商户]',
    ave_score      decimal(8, 2) default 0.0 comment '店铺评分',
    service_acc    varchar(128) null comment '客服账号',# ==
    validity       datetime     null comment '店铺有效期',
    del_flg        char          default '0' comment '删除标记[0-未删除|1-删除]',
    created_by     varchar(64)  not null,
    created_at     datetime     not null,
    updated_by     varchar(64)  null,
    updated_at     datetime     null,
    deleted_by     varchar(64)  null,
    deleted_at     datetime     null,
    comment        varchar(500)
) engine = InnoDB comment '店铺基础信息';

create unique index uidx_gsi_store_id on goblin_store_info (store_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_store_certification;
create table goblin_store_certification
(
    mid                  bigint auto_increment primary key,
    store_id             varchar(64)  not null comment '店铺id',
    person_cert_type     char default '0' comment '证件类型[1-二代居民身份证]',
    person_name          varchar(32)  null comment '证件姓名',
    person_cert_code     varchar(32)  null comment '证件号码',
    person_cert_validity varchar(50)  null comment '证件有效期',
    person_cert_lasting  char         null comment '证件是否长期有效[0-否|1-是]',
    person_cert_fpic     varchar(256) null comment '证件正面照',
    person_cert_bpic     varchar(256) null comment '证件背面照',
    person_cert_spic     varchar(256) null comment '证件手持照',
    del_flg              char default '0' comment '删除标记[0-未删除|1-删除]',
    province_id          varchar(20)  null comment '省id',
    province_name        varchar(32)  null comment '省名称',
    city_id              varchar(20)  null comment '市id',
    city_name            varchar(32)  null comment '市名称',
    county_id            varchar(20)  null comment '县id',
    county_name          varchar(32)  null comment '县名称',
    bus_address          varchar(128) null comment '详细地址',
    bus_name             varchar(64)  null comment '商户名称',
    bus_cert_code        varchar(32)  null comment '统一社会信用代码',
    bus_cert_validity    varchar(50)  null comment '营业执照有效期',
    bus_cert_lasting     char default '0' comment '证件是否长期有效[0-否|1-是]',
    bus_cert_pic         varchar(256) null comment '营业执照照片',
    bus_quality_pic      varchar(256) null comment '资质证书',
    created_by           varchar(64)  not null,
    created_at           datetime     not null,
    updated_by           varchar(64)  null,
    updated_at           datetime     null,
    deleted_by           varchar(64)  null,
    deleted_at           datetime     null,
    comment              varchar(500)
) engine = InnoDB comment '店铺认证信息';

create unique index uidx_gsc_store_id on goblin_store_certification (store_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_store_config;
create table goblin_store_config
(
    mid         bigint auto_increment primary key,
    store_id    varchar(64) not null comment '店铺id',
    config_name varchar(50) comment '参数名称',
    config_key  varchar(100) comment '参数键名',
    config_val  varchar(500) comment '参数键值',
    config_desc varchar(100) comment '参数描述',
    config_type char default '0' comment '保留字段',
    created_by  varchar(64) not null,
    created_at  datetime    not null,
    updated_by  varchar(64) null,
    updated_at  datetime    null,
    comment     varchar(500)
) engine = InnoDB comment '店铺设置';

create index idx_gsc_store_id on goblin_store_config (store_id);

insert into goblin_store_config (store_id, config_name, config_key, config_val, created_by, created_at)
values (0, '营业状态', 'BUSINESS_STATUS', '5', 'admin', sysdate()),
       (0, '联系客服', 'ONOFF_CUSTOMER_SEV', 'OFF', 'admin', sysdate()),
       (0, '售罄展示', 'ONOFF_SOLD_OUT_SHOW', 'OFF', 'admin', sysdate()),
       (0, '库存不足', 'LIMIT_WARNING_STOCK', '5', 'admin', sysdate());
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_store_notice;
create table goblin_store_notice
(
    mid          bigint auto_increment primary key,
    notice_id    varchar(32)  not null comment '公告id',
    store_id     varchar(64)  not null comment '店铺id',
    content      varchar(255) not null comment '公告内容',
    release_time datetime     not null comment '发布时间',
    long_lasting char default '0' comment '长期有效[0-否|1-是]',
    cancell_time datetime     null comment '结束时间',
    status       char default '0' comment '公告状态[0-待发布|1-已发布]',
    del_flg      char default '0' comment '删除标记[0-未删除|1-删除]',
    created_by   varchar(64)  not null,
    created_at   datetime     not null,
    updated_by   varchar(64)  null,
    updated_at   datetime     null,
    comment      varchar(500)
) engine = InnoDB comment '店铺公告';

create index idx_goblin_store_notice on goblin_store_notice (store_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_store_goods_category;
create table goblin_store_goods_category
(
    mid        bigint auto_increment primary key,
    store_id   varchar(64) not null comment '店铺id',
    cate_id    varchar(30) not null comment '分类id',
    name       varchar(50) not null comment '分类名称',
    sort       int  default 0 comment '排序[数值越小,排序越前]',
    grade      char        null comment '分类层级[1-一级|2-二级|3-三级]',
    cate_pid   varchar(30) null comment '父级分类id',
    ne_isbn    char default '0' comment '是否需要填写ISBN[0-否|1-是]',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    counts     int  default 0 comment '关联商品计数',
    created_by varchar(64) not null,
    created_at datetime    not null,
    updated_by varchar(64) null,
    updated_at datetime    null,
    deleted_by varchar(64) null,
    deleted_at datetime    null,
    comment    varchar(255)
) engine = InnoDB comment '商铺商品分类';

create index idx_gsgc_store_id on goblin_store_goods_category (store_id);
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_service_support;
create table goblin_goods_service_support
(
    mid     bigint auto_increment primary key,
    spu_id  varchar(64) not null comment '商品id',
    ssid    varchar(30) not null comment '服务支持id，对应 goblin_service_support.ssid',
    del_flg char default '0' comment '删除标记[0-未删除|1-删除]',
    comment varchar(255)
) engine = InnoDB comment '商品关联服务支持';

create unique index uidx_ggss_spu_ssid on goblin_goods_service_support (spu_id, ssid);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_tag;
create table goblin_goods_tag
(
    mid        bigint auto_increment primary key,
    spu_id     varchar(64) not null comment '商品id',
    tag_id     varchar(30) not null comment '标签id，对应 goblin_self_tag.tag_id',
    sort       int  default 0 comment '排序[数值越小,排序越前]',
    tag_belong char default '0' comment '标签所属[0-普通标签|1-专属标签]',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    comment    varchar(255)
) engine = InnoDB comment '商品关联标签';

create unique index uidx_ggt_spu_tag on goblin_goods_tag (spu_id, tag_id);
# 临时添加用作商品关联现场AR标签
drop table if exists goblin_goods_artag;
create table goblin_goods_artag
(
    mid        bigint auto_increment primary key,
    spu_id     varchar(64) not null comment '商品id',
    tag_id     varchar(30) not null comment '标签id，对应 goblin_self_tag.tag_id',
    sort       int  default 0 comment '排序[数值越小,排序越前]',
    tag_belong char default '0' comment '标签所属[0-普通标签|1-专属标签]',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    comment    varchar(255)
) engine = InnoDB comment '商品关联标签';

create unique index uidx_gga_spu_tag on goblin_goods_artag (spu_id, tag_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_image;
create table goblin_goods_image
(
    mid     bigint auto_increment primary key,
    spu_id  varchar(64)  not null comment '商品id',
    url     varchar(256) not null comment '图片地址',
    del_flg char default '0' comment '删除标记[0-未删除|1-删除]',
    comment varchar(255)
) engine = InnoDB comment '商品图片';

create unique index uidx_ggi_spu_url on goblin_goods_image (spu_id, url);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods;
create table goblin_goods
(
    mid                bigint auto_increment primary key,
    spu_id             varchar(64)      not null comment '商品id',
    spu_no             varchar(45)      not null comment '商品编码',
    name               varchar(100)     not null comment '商品名称',
    subtitle           varchar(128)     null comment '商品副标题',

    sell_price         decimal(20, 2)   null comment '销售价-原价',
    price_ge           decimal(20, 2)   null comment '价格区间MIN',
    price_le           decimal(20, 2)   null comment '价格区间MAX',
    intro              varchar(256)     null comment '商品简介',
    details            text             null comment '详情',
    cover_pic          varchar(256)     null comment '封面图片地址',
    video              varchar(256)     null comment '商品视频地址',
    spec_mode          char default '1' not null comment '规格展现方式[1-常规|2-组合]',

    store_id           varchar(64)      null comment '商品的店铺id，如果是平台的则为0',
    cate_fid           varchar(30)      null comment '平台一级分类id',
    cate_sid           varchar(30)      null comment '平台二级分类id',
    cate_tid           varchar(30)      null comment '平台三级分类id',
    store_cate_fid     varchar(30)      null comment '店铺一级分类id',
    store_cate_sid     varchar(30)      null comment '店铺二级分类id',
    store_cate_tid     varchar(30)      null comment '店铺三级分类id',
    brand_id           varchar(30)      null comment '品牌id',

    shelves_handle     char default '1' comment '上架处理方式[1-等待手动上架|2-直接上架售卖|3-预约定时上架]',
    shelves_time       datetime         null comment '预约上架时间[上架处理方式为3-预约定时上架时需要指定]',
    spu_validity       datetime         null comment '商品有效期[YYYY-MM-DD]',
    virtual_flg        char default '0' comment '是否虚拟商品[0-否|1-是]',
    status             char default '0' null comment '审核状态[0-编辑中|1-审核中|2-审核不通过|3-审核通过]',
    reason             varchar(256)     null comment '审核拒绝原因',
    shelves_status     char default '0' null comment '商品上架状态[0-待上架|1-下架|2-违规|3-上架]',
    spu_appear         char default '0' not null comment '自定义展示[0-默认展示|1-隐藏不可购买]',
    del_flg            char default '0' comment '删除标记[0-未删除|1-删除]',

    shelves_at         datetime         null comment '上架时间',
    created_by         varchar(64)      not null,
    created_at         datetime         not null,
    updated_by         varchar(64)      null,
    updated_at         datetime         null,
    deleted_by         varchar(64)      null,
    deleted_at         datetime         null,
    logistics_template varchar(64)      null comment '物流模版id',
    comment
                       varchar(500)
) engine = InnoDB comment '商品信息';

create unique index uidx_gg_spu_id on goblin_goods (spu_id);
create index idx_gg_store_id on goblin_goods (store_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_sku;
create table goblin_goods_sku
(
    sku_id             varchar(64)      not null primary key,
    spu_id             varchar(64)      not null comment '商品id',
    sku_no             varchar(45)      not null comment '单品的编号',
    name               varchar(100)     not null comment '单品的名称',
    subtitle           varchar(128)     null comment '单品的副标题',
    sell_price         decimal(20, 2)   null comment '单品销售价-原价',

    sku_pic            varchar(256)     null comment '单品默认图片的url',
    sku_isbn           varchar(50)      null comment 'ISBN，针对CD/图书等',
    stock              int              not null comment '总库存',
    sku_stock          int              not null comment '单品库存',
    warning_stock      int              null comment '预警库存',
    price              decimal(20, 2)   not null comment '单品现价',
    price_member       decimal(20, 2)   not null comment '单品会员价格',
    weight             decimal(20, 2)   null comment '单品的重量',
    buy_factor         char default '0' comment '购买限制[0-全部用户|1-仅会员|2-指定用户]',
    buy_roster         varchar(256)     null comment '购买限制人员名单[购买限制为2-指定用户时必填]',
    buy_limit          int              null comment '限量[0-无限制|X:限购数量]',

    store_id           varchar(64)      null comment '商品的店铺id，如果是平台的则为0',
    sku_validity       datetime         null comment '单品有效期',
    virtual_flg        char default '0' comment '是否是虚拟商品[0-否|1-是]',
    status             char default '0' null comment '审核状态[0-初始编辑|1-审核中|2-审核不通过|3-审核通过]',
    reason             varchar(256)     null comment '审核拒绝原因',
    shelves_status     char default '0' comment '单品上架状态[0-待上架|1-下架|2-违规|3-上架]',
    sku_appear         char default '0' not null comment '自定义展示[0-默认展示|1-隐藏不可购买]',
    del_flg            char default '0' comment '删除标记[0-未删除|1删除]',

    shelves_at         datetime         null comment '上架时间',
    created_by         varchar(64)      not null,
    created_at         datetime         not null,
    updated_by         varchar(64)      null,
    updated_at         datetime         null,
    deleted_by         varchar(64)      null,
    deleted_at         datetime         null,
    logistics_template varchar(64)      null comment '物流模版id',
    comment            varchar(500)
) engine = InnoDB comment '商品单品';

create index idx_ggs_spu_id on goblin_goods_sku (spu_id);
create index idx_ggs_store_id on goblin_goods_sku (store_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_buy_roster_log;
create table goblin_goods_buy_roster_log
(
    mid             bigint auto_increment primary key,
    sku_id          varchar(64) not null comment '对应 goblin_goods_sku.sku_id',
    buy_roster      varchar(30) not null comment '限购名单',
    buy_roster_type tinyint     null comment '删除标记[1-添加|2-删除]',
    parsing_result  varchar(30) null comment '解析结果[1-成功|2-失败]',
    operator        varchar(64) null,
    created_at      datetime    not null,
    comment         varchar(255)
) engine = InnoDB comment '商品限购名单处理记录';
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_spu_spec_value;
create table goblin_goods_spu_spec_value
(
    mid      bigint auto_increment primary key,
    spu_id   varchar(64) not null comment '商品id，对应 goblin_goods.spu_id',
    spec_name  varchar(30) not null comment '规格，对应 goblin_goods_spec.spec_name',
    spec_vname varchar(30) not null comment '规格值，对应 goblin_goods_spec_value.spec_vname',
    sort     int  default 0 comment '排序，数值越小排序越前',
    del_flg  char default '0' comment '删除标记[0-未删除|1-删除]',
    comment  varchar(255)
) engine = InnoDB comment '商品关联规格值';

create unique index uidx_ggssv_spu_spec on goblin_goods_spu_spec_value (spu_id, spec_name, spec_vname);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_sku_spec_value;
create table goblin_goods_sku_spec_value
(
    mid      bigint auto_increment primary key,
    spu_id   varchar(64) not null comment '商品id，对应 goblin_goods.spu_id',
    sku_id   varchar(64) not null comment '单品id，对应 goblin_goods_sku.sku_id',
    spec_name  varchar(30) not null comment '规格名称，对应 goblin_goods_spec.spec_name',
    spec_vname varchar(30) not null comment '规格值名称，对应 goblin_goods_spec_value.spec_vname',
#     sort     int  default 0 comment '排序，数值越小排序越前',
    del_flg  char default '0' comment '删除标记[0-未删除|1-删除]',
    comment  varchar(255)
) engine = InnoDB comment '单品关联规格值';

create unique index uidx_ggssv_spu_sku_spec on goblin_goods_sku_spec_value (spu_id, sku_id, spec_name, spec_vname);
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_spec_value;
create table goblin_goods_spec_value
(
    mid        bigint auto_increment primary key,
    spec_name    varchar(30)  not null comment '规格名称，对应 goblin_goods_spec.spec_name',
#     spec_vid   varchar(30)  not null comment '规格值id',
    spec_vname varchar(90) not null comment '规格值名称',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    created_by varchar(64)  not null,
    created_at datetime     not null,
    updated_by varchar(64)  null,
    updated_at datetime     null,
    comment    varchar(255)
) engine = InnoDB comment '商品规格值';

create unique index uidx_ggsv_spec on goblin_goods_spec_value (spec_name, spec_vname);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_spec;
create table goblin_goods_spec
(
    mid        bigint auto_increment primary key,
#     spec_id    varchar(30) not null comment '规格id',
    spec_name  varchar(45) not null comment '规格名称',
    spec_alias varchar(100) null comment '规格别名',
    del_flg    char default '0' comment '删除标记[0-未删除|1-删除]',
    created_by varchar(64) not null,
    created_at datetime    not null,
    updated_by varchar(64) null,
    updated_at datetime    null,
    comment    varchar(255)
) charset = utf8 comment '商品规格';

create unique index uidx_ggs_spec on goblin_goods_spec (spec_name);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_goods_category_spec;
create table goblin_goods_category_spec
(
    mid     bigint auto_increment primary key,
    cate_id varchar(30) not null comment '分类id，对应 goblin_self_goods_category.cate_id',
    spec_name varchar(30) not null comment '规格名称，对应 goblin_goods_spec.spec_name',
    del_flg char default '0' comment '删除标记[0-未删除|1-删除',
    comment varchar(255)
) engine = InnoDB comment '分类关联规格';

create unique index uidx_ggcs_cate_spec on goblin_goods_category_spec (cate_id, spec_name);
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
DROP TABLE IF EXISTS `goblin_front_banner`;
CREATE TABLE `goblin_front_banner` (
  `mid` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
  `pic_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图片路径',
  `indexs` int DEFAULT NULL COMMENT '排序',
  `jump_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '1、票务2、H5、3票务',
  `start_time` timestamp NULL DEFAULT NULL COMMENT '开启时间',
  `end_time` timestamp NULL DEFAULT NULL COMMENT '结束时间',
  `activity_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '活动url',
  `ticket_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '票务名字',
  `banner_type` int DEFAULT NULL COMMENT '1、首页顶部位置2、首页中部位置',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  `banner_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'bannerId',
  `del_tag` int DEFAULT NULL COMMENT '0未删除1已删除',
  `ticket_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '票务id',
  PRIMARY KEY (`mid`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='轮播图';

DROP TABLE IF EXISTS `goblin_front_compilations`;
CREATE TABLE `goblin_front_compilations` (
  `mid` bigint NOT NULL AUTO_INCREMENT,
  `compilations_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '合集id',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '合集名称',
  `spu_ids` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'spu ids',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  `del_tag` int DEFAULT NULL COMMENT '0未删除1已删除',
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图片',
  `spu_count` int DEFAULT NULL COMMENT '商品数量',
  `describes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '描述',
  PRIMARY KEY (`mid`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='合集';
DROP TABLE IF EXISTS `goblin_front_cube`;
CREATE TABLE `goblin_front_cube` (
  `mid` bigint NOT NULL AUTO_INCREMENT,
  `cube_id` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '魔方id',
  `row_type` int DEFAULT NULL COMMENT '1、一行一个2一行二个3一行三个4上一下三',
  `page_type` int DEFAULT NULL COMMENT '1、单商品2、合集',
  `spu_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '商品名称',
  `spu_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '商品id',
  `information_a` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '推荐文案1',
  `compilations_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '合集id',
  `create_time` timestamp NULL DEFAULT NULL,
  `update_time` timestamp NULL DEFAULT NULL,
  `del_tag` int DEFAULT NULL COMMENT '0未删除1已删除',
  `information_b` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '推荐文案1',
  `information_c` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '推荐文案2',
  `information_d` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '推荐文案3',
  `type` int DEFAULT NULL COMMENT '1、魔方2、新品推荐',
  PRIMARY KEY (`mid`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ----------------------------
-- Table structure for goblin_front_hot_word
-- ----------------------------
DROP TABLE IF EXISTS `goblin_front_hot_word`;
CREATE TABLE `goblin_front_hot_word` (
  `mid` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
  `word` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '热词',
  `status` int DEFAULT NULL COMMENT '1开启2未开启',
  `indexs` int DEFAULT NULL COMMENT '排序',
  `change_type` int DEFAULT NULL COMMENT '1、滚动2、按时切换',
  `change_time` int DEFAULT NULL COMMENT '切换时间单位为s',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  `hot_word_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '热词id',
  `del_tag` int DEFAULT NULL COMMENT '0未删除1已删除',
  PRIMARY KEY (`mid`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='热词\n';

-- ----------------------------
-- Table structure for goblin_front_moudle_index
-- ----------------------------
DROP TABLE IF EXISTS `goblin_front_moudle_index`;
CREATE TABLE `goblin_front_moudle_index` (
  `mid` bigint NOT NULL AUTO_INCREMENT,
  `moudle_index_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '组件排序id',
  `moudle_name` varchar(64) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '名字',
  `indexs` int DEFAULT NULL COMMENT '顺序',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `del_tag` int DEFAULT NULL COMMENT '0未删除1已删除',
  `status` int DEFAULT NULL COMMENT '0展示2不展示',
  PRIMARY KEY (`mid`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='组件排序';

BEGIN;
INSERT INTO `goblin_front_moudle_index` VALUES (1, '708753099180072962244503', 'huDongBanner', 2, '2022-01-21 14:13:58', '2022-01-06 13:52:19', 0, 0);
INSERT INTO `goblin_front_moudle_index` VALUES (2, '708754120962334729770775', 'jinGangWei', 4, '2022-01-21 14:13:46', '2022-01-06 13:53:45', 0, 0);
INSERT INTO `goblin_front_moudle_index` VALUES (3, '708754120962334729770777', 'xianShiMiaoSha', 3, '2022-01-06 13:55:04', '2022-01-06 13:55:07', 0, 0);
INSERT INTO `goblin_front_moudle_index` VALUES (4, '708754120962334729772770', 'moFang', 2, '2022-01-21 14:14:45', '2022-01-06 13:55:34', 0, 0);
INSERT INTO `goblin_front_moudle_index` VALUES (5, '70875412096233472977232', 'XINPINTUIJIAN', 4, '2022-02-21 14:45:55', '2022-02-21 14:45:55', 0, 0);
COMMIT;
-- ----------------------------
-- Table structure for goblin_front_navigation
-- ----------------------------
DROP TABLE IF EXISTS `goblin_front_navigation`;
CREATE TABLE `goblin_front_navigation` (
  `mid` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
  `pic_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '图片路径或id',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '标题',
  `spu_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '商品id',
  `display_type` int DEFAULT NULL COMMENT '展示形式：1、一行2、二行',
  `category_type` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT '分类',
  `activity_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '活动链接',
  `navigation_type` int DEFAULT NULL COMMENT '1、分类2、专题3、商品单品',
  `indexs` int DEFAULT NULL COMMENT '顺序',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  `navigation_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '导航id',
  `del_tag` int DEFAULT NULL COMMENT '0未删除1已删除',
  `spu_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '商品名字',
  PRIMARY KEY (`mid`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='首页导航栏\n';

-- ----------------------------
-- Table structure for goblin_front_seckill
-- ----------------------------
DROP TABLE IF EXISTS `goblin_front_seckill`;
CREATE TABLE `goblin_front_seckill` (
  `mid` bigint NOT NULL AUTO_INCREMENT COMMENT '主键',
  `self_activityIds` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '活动id(官方g_,商铺s_)',
  `show_type` int DEFAULT NULL COMMENT '1、一行三个2、两行三个',
  `activityType` int DEFAULT NULL COMMENT '1、关闭模块2、保留模块',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  `del_tag` int DEFAULT NULL COMMENT '0未删除1已删除',
  `indexs` int DEFAULT NULL COMMENT '排序',
  `seckil_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '秒杀id',
  PRIMARY KEY (`mid`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='秒杀表';

-- ----------------------------
-- Table structure for goblin_front_select_goods
-- ----------------------------
DROP TABLE IF EXISTS `goblin_front_select_goods`;
CREATE TABLE `goblin_front_select_goods` (
  `mid` bigint NOT NULL AUTO_INCREMENT,
  `select_goods_id` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT '商品id',
  `spu_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'spu的 ids拼接',
  `del_tag` int DEFAULT NULL COMMENT '0未删除1已删除',
  `create_time` timestamp NULL DEFAULT NULL COMMENT '创建时间',
  `update_time` timestamp NULL DEFAULT NULL COMMENT '修改时间',
  `order_type` int DEFAULT NULL COMMENT '1、上架时间2、销量3、价格高到低4、价格低到高',
  `indexs` int DEFAULT NULL COMMENT '顺序',
  PRIMARY KEY (`mid`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='精选商品\n';
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------

-- 大美
drop table if exists goblin_store_order;
create table goblin_store_order
(
    mid                  bigint unsigned auto_increment primary key,
    order_id             varchar(64)   default '' comment '订单id',
    store_id             varchar(64)   default '' comment '店铺id',
    master_order_code    varchar(64)   default '' comment '主订单code  下单可能会同时下多个订单 ',
    order_code           varchar(64)   default '' comment '订单号',
    pay_code             varchar(64)   default '' comment '支付单号',
    user_id              varchar(64)   default '' comment '用户id',
    user_name            varchar(64)   default '' comment '用户昵称',
    user_mobile          varchar(64)   default '' comment '用户手机号',
    price_total          decimal(8, 2) default 0.0 comment '应付金额',
    price_actual         decimal(8, 2) default 0.0 comment '实付金额',
    price_refund         decimal(8, 2) default 0.0 comment '退款价格',
    pre_sale_price       decimal(8, 2) default 0.0 comment '预售价格',
    price_express        decimal(8, 2) default 0.0 comment '快递价格',
    price_modify         decimal(8, 2) default 0.0 comment '管理员修改优惠金额',
    price_point          decimal(8, 2) default 0.0 comment '积分优惠金额',
    price_coupon         decimal(8, 2) default 0.0 comment '券优惠金额',
    price_red_envelope   decimal(8, 2) default 0.0 comment '红包优惠金额',
    price_voucher        decimal(8, 2) default 0.0 comment '总优惠价格',
    status               int           default 0 comment '订单状态[0-待付款(用户刚下单)|2-代发货(用户付完款 等待商城发货)|3-代收货(商城已经发货 等待用户确认收货)|4-已完成(用户已经确认收货 订单结束)|5-取消订单(用户未付款前取消订单)|6-退款通过(用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款)|7-退货通过(用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品)|61-6的发起状态|71-7的发起状态]',
    status_pre_sale      int           default 0 comment '预售订单状态[0-第一阶段未支付|1-第一阶段支付第二阶段未支付|3-第二阶段支付]',
    status_evaluation    int           default 0 comment '评价状态[0-未评价|1-已评价]',
    red_envelope_code    varchar(64)   default '' comment '红包code',
    ucoupon_id           varchar(64)   default '' comment '券id',
    use_point            decimal       default 0.0 comment '使用积分数',
    pay_type             varchar(32)   default '' comment '支付类型[wepay-微信支付|alipay-阿里支付|douyinpay-抖音支付|unionpay-银联支付]',
    device_from          varchar(32)   default '' comment '支付类型来源[wap|js]',
    payment_type         varchar(32)   default '' comment '支付中心返回实际支付类型',
    payment_id           varchar(128)   default '' comment '支付中心返回支付id',
    cancel_reason        varchar(256)  default '' comment '取消原因',
    pre_deposit_pay      int           default 0 comment '是否存在预付款[0-不存在|1-存在]',
    source               varchar(32)   default '' comment '订单来源[app|h5|applet]',
    version              varchar(32)   default '' comment '版本号',
    is_member            int(8)        default 0 comment '是否会员',
    order_type           int           default 0 comment '订单类型[0-普通订单|1-定金预售订单|2-全款预售订单|3-拼团订单|4-众筹全款|5-众筹1元|6-众筹无回报|7-虚拟商品订单|8-社区团购订单|9-正在下单]',
    pay_time             datetime      default null comment '支付时间',
    cancel_time          datetime      default null comment '取消时间',
    modify_time          datetime      default null comment '管理员修改订单时间',
    evaluation_time      datetime      default null comment '评价时间',
    pre_sale_time        datetime      default null comment '预售订单的时间[对于定金预售则是第二阶段付款时间和发货时间|对于全款预售则是发货时间]',
    recommended_id       varchar(64)   default '' comment '订单推广人的会员id(订单会员的推广人 ，也就是订单会员的上级的id) 如果为'' 则说明该订单会员没有推荐人或者不是推广订单',
    s_recommended_id     varchar(64)   default '' comment '订单二级推广人的会员id(订单会员的二级推广人 ，也就是订单会员的上级的上级会员id) 如果为'' 则说明该订单会员没有推荐人或者不是推广订单',
    crowdfunding_id      varchar(64)   default '' comment '众筹id',
    lottery_status       varchar(64)   default '' comment '抽奖状态[0-未抽奖|1-中奖|2-已抽奖]',
    write_off_code       varchar(64)   default '' comment '虚拟订单核销码[正在支付取货码]',
    pay_store_id         varchar(64)   default '' comment '钱到了哪个支付平台  平台的订单id为''',
    pay_countdown_minute int           DEFAULT 5 COMMENT '订单过期时间(分钟)',
    ip_address           varchar(32)   DEFAULT '' COMMENT 'ip地址',
    area                 varchar(32)   DEFAULT NULL COMMENT 'ip地域全名称',
    area_province        varchar(32)   DEFAULT NULL COMMENT 'ip地域省',
    area_city            varchar(32)   DEFAULT NULL COMMENT 'ip地域市',
    area_county          varchar(32)   DEFAULT NULL COMMENT 'ip地域县',
    mail_no              varchar(64)   default '' comment '快递单号',
    delivery_time        datetime      default null comment '发货时间',
    logistics_company    varchar(32)   default '' comment '物流公司姓名',
    logistics_code       varchar(64)   default '' comment '物流公司code[物流公司id]',
    created_at           datetime,
    updated_at           datetime,
    comment              text,
    KEY `store_order_order_id_index` (`order_id`),
    KEY `store_order_store_id_index` (`store_id`),
    KEY `store_order_order_code_index` (`order_code`),
    KEY `store_order_user_id_index` (`user_id`),
    KEY `store_order_status_index` (`status`),
    KEY `store_order_ucoupon_id_index` (`ucoupon_id`),
    KEY `store_order_pay_type_index` (`pay_type`),
    KEY `store_order_order_type_index` (`order_type`)
) engine = InnoDB comment '商城订单表';


drop table if exists goblin_order_attr;
create table goblin_order_attr
(
    mid                      bigint unsigned auto_increment primary key,
    order_attr_id            varchar(64)  default '' comment '订单attr_id',
    order_id                 varchar(64)  default '' comment '订单id',
    express_contacts         varchar(64)  default '' comment '收货人',
    express_address          varchar(255) default '' comment '收货地址[省市区]',
    express_address_detail   varchar(255) default '' comment '收货地址[省市区]',
    express_phone            varchar(64)  default '' comment '收货人联系方式',
    express_type             tinyint      default 1 comment '快递方式 [1寄付|2到付|3-包邮]',
    invoice_type             int          default 0 comment '发票类型 [0-不需要发票|1增值税普票|2增值税专票]',
    invoice_title            varchar(64)  default '' comment '发票抬头',
    invoice_content          int          default 0 comment '发票内容[1-非图书商品|2-明细|3-耗材|4-办公用品]',
    invoice_tax_id           varchar(64)  default '' comment '税号',
    invoice_company_name     varchar(64)  default '' comment '单位名称',
    invoice_register_address varchar(64)  default '' comment '注册地址',
    invoice_register_mobile  varchar(64)  default '' comment '注册手机号',
    invoice_open_bank        varchar(64)  default '' comment '开户行',
    invoice_bank_account     varchar(64)  default '' comment '银行账号',
    invoice_title_type       int          default 2 comment '抬头类型[1-企业|2-个人]',
    remark                   varchar(255) default '' comment '备注',
    gift_infos               text         default null comment '订单的赠品信息格式为JSON',
    donation_message         varchar(255) default '' comment '捐赠寄语',
    created_at               datetime,
    updated_at               datetime,
    comment                  text,
    KEY `order_attr_order_id_index` (`order_id`),
    KEY `order_attr_express_type_index` (`express_type`),
    KEY `order_attr_invoice_type_index` (`invoice_type`),
    KEY `order_attr_invoice_content_index` (`invoice_content`),
    KEY `order_attr_invoice_title_type_index` (`invoice_title_type`)
) engine = InnoDB comment '商城订单属性表';

drop table if exists goblin_order_sku;
create table goblin_order_sku
(
    mid               bigint unsigned auto_increment primary key,
    order_sku_id      varchar(64)   default '' comment '订单sku_id',
    order_id          varchar(64)   default '' comment '订单id',
    spu_id            varchar(64)   default '' comment '商品id',
    sku_id            varchar(64)   default '' comment '款式id',
    status            int           default 0 comment '订单状态[0-待付款(用户刚下单)|2-代发货(用户付完款 等待商城发货)|3-代收货(商城已经发货 等待用户确认收货)|4-已完成(用户已经确认收货 订单结束)|5-取消订单(用户未付款前取消订单)|6-退款通过(用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款)|7-退货通过(用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品)|61-6的发起状态|71-7的发起状态]',
    num               int           default 0 comment '数量',
    sku_price         decimal(8, 2) default 0 comment '款式原价',
    sku_price_actual  decimal(8, 2) default 0 comment '款式实付价',
    price_refund      decimal(8, 2) default 0.0 comment '退款价格',
    sku_name          varchar(64)   default '' comment '款式名称',
    sku_no            varchar(64)   default '' comment '款式编号',
    sku_image         varchar(128)  default '' comment '款式图片',
    sku_specs         varchar(256)  default '' comment '款式规格',
    price_modify      decimal(8, 2) default 0 comment '管理员优惠价格',
    price_voucher     decimal(8, 2) default 0 comment '款式最终优惠价',
    commission_rate   decimal(8, 2) default 0 comment '单品的分拥比例 0 表示不分佣金',
    s_commission_rate decimal(8, 2) default 0 comment '单品的分拥比例 0 表示不分佣金',
    cate_rate         decimal(8, 2) default 0 comment '分类扣率',
    created_at        datetime,
    updated_at        datetime,
    comment           text,
    KEY `order_sku_order_id_index` (`order_id`),
    KEY `order_sku_spu_id_index` (`spu_id`),
    KEY `order_sku_sku_id_index` (`sku_id`)
) engine = InnoDB comment '订单单品表';

drop table if exists goblin_order_operation_log;
create table goblin_order_operation_log
(
    mid            bigint unsigned auto_increment primary key,
    order_log_id   varchar(64)  default '' comment '订单操作日志id',
    order_id       varchar(64)  default '' comment '订单id',
    type           int          default 0 comment '操作类型[1-确认付款|2-修改金额|3-发货|4-取消订单|5-修改物流单号|6-核销虚拟商品订单]',
    remark         varchar(2048) default '' comment '说明',
    operation_name varchar(32)  default '' comment '操作人',
    created_at     datetime,
    updated_at     datetime,
    comment        text,
    KEY `order_operation_log_order_id_index` (`order_id`),
    KEY `order_operation_log_type_index` (`type`)
) engine = InnoDB comment '订单操作日志表';


drop table if exists goblin_shopping_cart;
create table goblin_shopping_cart
(
    mid          bigint unsigned auto_increment primary key,
    car_id       varchar(64) default '' comment '购物车id',
    user_id      varchar(64) default '' comment '用户id',
    store_id     varchar(64) default '' comment '商铺id',
    spu_id       varchar(64) default '' comment '商品id',
    sku_id       varchar(64) default '' comment '款式id',
    number       int         default 0 comment '数量',
    marketing_id varchar(64) default '' comment '默认的营销id[活动id]',
    del_tag      int         default 0 comment '删除标记[0-未删除|1-已删除]',
    created_at   datetime,
    updated_at   datetime,
    comment      text,
    KEY `shopping_cart_user_id_index` (`user_id`),
    KEY `shopping_cart_store_id_index` (`store_id`),
    KEY `shopping_cart_spu_id_index` (`spu_id`),
    KEY `shopping_cart_sku_id_index` (`sku_id`),
    KEY `shopping_cart_marketing_id_index` (`marketing_id`),
    KEY `shopping_cart_del_tag_index` (`del_tag`)
) engine = InnoDB comment '购物车表';

drop table if exists goblin_back_order;
create table goblin_back_order
(
    mid                bigint unsigned auto_increment primary key,
    back_order_id      varchar(64)   default '' comment '订单退单表id',
    back_code          varchar(64)   default '' comment '退款单号',
    order_id           varchar(64)   default '' comment '订单id',
    order_code         varchar(64)   default '' comment '订单编号',
    store_id           varchar(64)   default '' comment '商铺id',
    user_id            varchar(64)   default '' comment '用户id',
    sku_id_nums        varchar(255)  default '' comment '退货的单品ID多个用,分开  退款的时候不需要，因为退款只能整单退1001-1,1002-3 表示单品id为1001 的单品退货1件 单品id为1002的单品退货3件',
    type               int           default 0 comment '类型[1-退款|2-退货]',
    reason             varchar(255)  default '' comment '退款／退货原因[1-不想买了|2-收货人信息有误|3-未按指定时间发货|4-其他|5-不想买了|6-商品质量问题|7-收到商品与描述不符|8-其他|9-系统自动申请]',
    describes          varchar(255)  default '' comment '问题说明',
    credential         int           default 0 comment '申请凭据[0-没有任何凭据|1-有发票|2-有质检报告]',
    back_type          int           default 0 comment '返回方式[1-快递返回]目前只有快递返回 （退货的时候用户给商城寄送商品）',
    real_back_price    decimal(8, 2) default 0 comment '退货时候实际退款金额',
    pics               varchar(255)  default '' comment '上传的退款凭证或者质检发票 多个图片 用, 隔开',
    status             int           default 0 comment '退款／退货状态[1-退款申请(用户发送退款请求)|2-退款成功(商家同意退款)|3-退款拒绝(商家拒绝退款)|4-退货申请(用户发起退货请求)|5-退货拒绝(商家拒绝退货)|6-退货审核通过等待用户填写物流(商家审核通过，等待用户寄回商品)|7-待收货(用户已确认)|8-退货完成(商家收货并且同意退款给用户)|9-退货失败(商家不同意退款)',
    pre_deposit_pay    int           default 0 comment '是否预存款支付[0-否|1-是]',
    logis_company_name varchar(64)   default '' comment '物流公司名称',
    mail_no            varchar(64)   default '' comment '物流单号',
    created_at         datetime,
    updated_at         datetime,
    comment            text,
    KEY `back_order_back_order_id_index` (`back_order_id`),
    KEY `back_order_back_code_index` (`back_code`),
    KEY `back_order_order_id_index` (`order_id`),
    KEY `back_order_order_code_index` (`order_code`),
    KEY `back_order_store_id_index` (`store_id`),
    KEY `back_order_user_id_index` (`user_id`),
    KEY `back_order_type_index` (`type`),
    KEY `back_order_reason_index` (`reason`),
    KEY `back_order_credential_index` (`credential`),
    KEY `back_order_back_type_index` (`back_type`),
    KEY `back_order_status_index` (`status`),
    KEY `back_order_pre_deposit_pay_index` (`pre_deposit_pay`)
) engine = InnoDB comment '订单退单退款表';

drop table if exists goblin_back_order_log;
create table goblin_back_order_log
(
    mid               bigint unsigned auto_increment primary key,
    back_order_log_id varchar(64)  default '' comment '订单退单log表id',
    back_order_id     varchar(64)  default '' comment '退款订单id',
    operation_type    int          default 0 comment '操作人类型[1-用户|2-商家]',
    message           varchar(2048) default '' comment '留言',
    status            int          default 0 comment '退款申请[1-退款申请(用户发送退款请求)|2-退款成功(商家同意退款)|3-退款拒绝(商家拒绝退款)|4-退货申请(用户发起退货请求)|5-退货拒绝(商家拒绝退货)|6-退货审核通过等待用户填写物流(商家审核通过，等待用户寄回商品)|7-待收货(用户已确认)|8-退货完成(商家收货并且同意退款给用户)|9-退货失败(商家不同意退款)',
    created_at        datetime,
    updated_at        datetime,
    comment           text,
    KEY `back_order_log_market_id_index` (`back_order_id`),
    KEY `back_order_operation_type_index` (`operation_type`),
    KEY `back_order_status_index` (`status`)
) engine = InnoDB comment '订单退款退货操作日志表';


drop table if exists goblin_self_marketing;
create table goblin_self_marketing
(
    mid            bigint unsigned auto_increment primary key,
    self_market_id varchar(64)  default '' comment '官方营销表id',
    name           varchar(64)  default '' comment '营销名称',
    type           int          default 0 comment '营销类型[1-正在下单]',
    status         int          default 0 comment '活动状态[-1-全部|0-等待开始|1-活动中|2-活动结束|7-停用]',
    describes      varchar(255) default '' comment '营销描述',
    start_time     datetime     default null comment '营销开始时间',
    end_time       datetime     default null comment '营销结束时间营销为定金预售的时候，该时间也是第二阶段付款的时间营销为全款预售的时候，该时间也是发货时间',
    del_flag       int          default 0 comment '删除标记[0-未删除|1-删除]',
    created_at     datetime,
    updated_at     datetime,
    comment        text,
    KEY `self_marketing_self_market_id_index` (`self_market_id`),
    KEY `self_marketing_type_index` (`type`),
    KEY `self_marketing_start_time_index` (`start_time`),
    KEY `self_marketing_end_time_index` (`end_time`),
    KEY `self_marketing_del_flag_index` (`del_flag`),
    KEY `self_marketing_name_index` (`name`)
) engine = InnoDB comment '官方(平台)营销表[活动]表';

drop table if exists goblin_marketing_zhengzai_relation;
create table goblin_marketing_zhengzai_relation
(
    mid            bigint unsigned auto_increment primary key,
    self_market_id varchar(64) default '' comment '官方营销表id',
    store_id       varchar(64) default '' comment '商铺id',
    show_time      datetime    default null comment '可显示时间',
    del_tag        int         default 0 comment '删除标记[0-未删除|1-删除]',
    created_at     datetime,
    updated_at     datetime,
    comment        text,
    KEY `marketing_zhengzai_relation_self_market_id_index` (`self_market_id`),
    KEY `marketing_zhengzai_relation_tore_id_index` (`store_id`),
    KEY `marketing_zhengzai_relation_del_tag_index` (`del_tag`)
) engine = InnoDB comment '可参加官方活动的店铺表';

drop table if exists goblin_marketing_zhengzai;
create table goblin_marketing_zhengzai
(
    mid             bigint unsigned auto_increment primary key,
    zhengzai_id     varchar(64)   default '' comment '正在下单营销id',
    self_market_id  varchar(64)   default '' comment '官方营销表id',
    store_id        varchar(64)   default '' comment '商铺id',
    spu_id          varchar(64)   default '' comment '商品id',
    sku_id          varchar(64)   default '' comment '款式id',
    price_marketing decimal(8, 2) default 0 comment '活动价格',
    stock_marketing int           default 0 comment '活动库存',
    buy_factor      int           default 0 comment '购买限制[0-全部用户|1-仅会员|2-指定用户]',
    buy_roster      varchar(128)  default '' comment '购买限制人员名单[购买限制为2-指定用户时必填]',
    buy_limit       int           default 0 comment '限量[0-无限制|X:限购数量]',
    del_flag        int           default 0 comment '删除标记[0-未删除|1-删除]',
    created_at      datetime,
    updated_at      datetime,
    comment         text,
    KEY `marketing_zhengzai_zhengzai_id_index` (`zhengzai_id`),
    KEY `marketing_zhengzai_self_market_id_index` (`self_market_id`),
    KEY `marketing_zhengzai_store_id_index` (`store_id`),
    KEY `marketing_zhengzai_spu_id_index` (`spu_id`),
    KEY `marketing_zhengzai_sku_id_index` (`sku_id`),
    KEY `marketing_zhengzai_buy_limit_index` (`buy_limit`),
    KEY `marketing_zhengzai_buy_type_index` (`buy_factor`)
) engine = InnoDB comment '官方正在下单营销内容表';

drop table if exists goblin_store_marketing;
create table goblin_store_marketing
(
    mid             bigint unsigned auto_increment primary key,
    store_market_id varchar(64)  default '' comment '商铺营销表id',
    name            varchar(64)  default '' comment '营销名称',
    type            int          default 0 comment '营销类型[1-满赠|2-限时秒杀]',
    store_id        varchar(64)  default '' comment '商铺id',
    status          int          default 0 comment '活动状态[-1-全部|0-等待开始|1-活动中|2-活动结束|7-停用]',
    describes       varchar(255) default '' comment '营销描述',
    start_time      datetime     default null comment '营销开始时间',
    end_time        datetime     default null comment '营销结束时间营销为定金预售的时候，该时间也是第二阶段付款的时间营销为全款预售的时候，该时间也是发货时间',
    del_flag        int          default 0 comment '删除标记[0-未删除|1-删除]',
    is_pre          int          default 0 comment '活动是否预热[0-否|1-是]',
    pre_time        datetime     default null comment '活动预热时间',
    created_at      datetime,
    updated_at      datetime,
    comment         text,
    KEY `store_market_store_market_id_index` (`store_market_id`),
    KEY `store_market_type_index` (`type`),
    KEY `store_market_store_id_index` (`store_id`),
    KEY `store_market_start_time_index` (`start_time`),
    KEY `store_market_end_time_index` (`end_time`),
    KEY `store_market_del_flag_index` (`del_flag`)
) engine = InnoDB comment '商铺营销表[活动]';


drop table if exists goblin_store_market_purchasing;
create table goblin_store_market_purchasing
(
    mid             bigint unsigned auto_increment primary key,
    purchase_id     varchar(64)   default '' comment '小时秒杀表id',
    store_market_id varchar(64)   default '' comment '商铺营销表id',
    spu_id          varchar(64)   default '' comment 'spu_id',
    sku_id          varchar(64)   default '' comment 'sku_id',
    store_id        varchar(64)   default '' comment '商铺id',
    price_marketing decimal(8, 2) default 0 comment '活动价格',
    stock_marketing int           default 0 comment '活动库存',
    buy_factor      int           default 0 comment '购买限制[0-全部用户|1-仅会员|2-指定用户]',
    buy_roster      varchar(128)  default '' comment '购买限制人员名单[购买限制为2-指定用户时必填]',
    buy_limit       int           default 0 comment '限量[0-无限制|X:限购数量]',
    del_flag        int           default 0 comment '删除标记[0-未删除|1-删除]',
    created_at      datetime,
    updated_at      datetime,
    comment         text,
    KEY `store_market_relation_sku_id_index` (`sku_id`),
    KEY `store_market_relation_store_id_index` (`store_id`),
    KEY `store_market_relation_del_flag_index` (`del_flag`)
) engine = InnoDB comment '营销秒杀表[活动]';

drop table if exists goblin_mail;
create table goblin_mail
(
    mid             bigint unsigned auto_increment primary key,
    mail_id     varchar(64)   default '' comment '快递id',
    order_id varchar(64)   default '' comment '订单id',
    mail_no          varchar(64)   default '' comment '快递单号',
    delivery_time          datetime   default null comment '发送时间',
    logistics_company        varchar(64)   default '' comment '快递公司名称',
    logistics_code varchar(64) default '' comment '快递公司编号',
    order_sku_ids text           default null comment '发送子订单',
    created_at      datetime,
    updated_at      datetime,
    comment         text,
    KEY `goblin_mail_mail_id_index` (`mail_id`),
    KEY `goblin_mail_order_id_index` (`order_id`)
) engine = InnoDB comment '订单快递表';

alter table goblin_store_order add store_name varchar(255) default '' comment '商铺名称';
alter table goblin_store_order add market_type varchar(255) default '' comment '活动类型[ZZ-正在下单]';
alter table goblin_store_order add market_id varchar(255) default '' comment '活动id';
alter table goblin_store_order add zhengzai_status int default 0 comment '正在下单是否出货[0-未出货|1-已出货]';
alter table goblin_self_marketing add performance_img varchar(128) default '' comment '演出图片';

alter table goblin_order_sku add spu_name varchar(255) default '' comment 'spu名称';
alter table goblin_order_sku add spu_pic varchar(255) default '' comment 'spu图片';

alter table goblin_store_order add store_name varchar(255) default '' comment '商铺名称';
alter table goblin_store_order add market_type varchar(255) default '' comment '活动类型[ZZ-正在下单]';
alter table goblin_store_order add market_id varchar(255) default '' comment '活动id';
alter table goblin_store_order add store_coupon_id varchar(255) default '' comment '商铺券id';
alter table goblin_store_order add store_price_coupon decimal (8,2) default 0 comment '商铺券优惠金额';


alter table goblin_back_order add back_price_express decimal (8,2) default 0 comment '退款快递费';
alter table goblin_back_order add refund_at datetime default null comment '退款时间';
alter table goblin_back_order add refuse_at datetime default null comment '拒绝时间';
alter table goblin_back_order add refund_size int default 0 comment '拒绝次数';
alter table goblin_back_order add audit_at datetime default null comment '审核时间';
alter table goblin_back_order add refuse_reason varchar(255) default '' comment '退款原因';


alter table goblin_back_order_log add operation_name varchar(255) default '' comment '操作人姓名';
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_store_coupon;
create table goblin_store_coupon
(
    mid             bigint unsigned auto_increment primary key,
    store_coupon_id varchar(64)      not null comment '卡券ID',
    store_coupon_no varchar(64)      not null comment '卡券编码',
    store_id        varchar(64)      not null comment '店铺ID',
    title           varchar(50)      not null comment '卡券名称',
    label           varchar(50)      null comment '标注',
    notice          varchar(255)     null comment '卡券描述',
    type            char             not null comment '券类型[1-代金券|2-折扣券|3-满减券]',

    stock           int              not null comment '卡券库存，默认：0为无限',
    triggers        decimal(8, 2)    null comment '触发金额',
    val_face        decimal(8, 2)    null comment '面值',
    discount        decimal(8, 2)    null comment '折扣[8折即0.8]',
    val_over        decimal(8, 2)    null comment '满减~满',
    val_minus       decimal(8, 2)    null comment '满减~减',
    deduction       decimal(8, 2)    null comment '抵扣上限金额（最多扣除金额）',

    overlay         char default '1' null comment '叠加限制[0-限制|1-叠加]',
    overlay_level   char default '0' null comment '#同类别券叠加适用',
    receive_limit   int  default 1 comment '限领数量，默认：1张/人',
    receive_curb    char             null comment '领取约束[0-不开放|1-开放]',
    use_scope       char             null comment '使用范围[0-全部商品|1-部分商品]',
    state           char             not null comment '卡券状态[0-等待开始|1-活动中|2-活动结束|3-停用]',
    start_time      datetime(3)      not null comment '开始时间',
    end_time        datetime(3)      not null comment '结束时间',
    del_flg         char default '0' comment '删除标记[0-未删除|1-删除]',
    created_by      varchar(64)      not null,
    created_at      datetime(3)      not null,
    updated_by      varchar(64)      null,
    updated_at      datetime(3)      null,
    deleted_by      varchar(64)      null,
    deleted_at      datetime(3)      null,
    comment         text
) engine = InnoDB comment '商铺营销-优惠券';

create unique index uidx_gsc_store_coupon_id on goblin_store_coupon (store_coupon_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_store_coupon_rule;
create table goblin_store_coupon_rule
(
    mid             bigint unsigned auto_increment primary key,
    store_coupon_id varchar(64) not null comment '卡券ID',
    spu_id          varchar(64) not null comment 'spu_id',
    sku_id          varchar(64) null comment 'sku_id',
    del_flg         char default '0' comment '删除标记[0-未删除|1-删除]',
    created_by      varchar(64) not null,
    created_at      datetime(3) not null,
    updated_by      varchar(64) null,
    updated_at      datetime(3) null,
    comment         text
) engine = InnoDB comment '商铺营销-优惠券规则';

create index idx_gscr_store_coupon_id on goblin_store_coupon_rule (store_coupon_id);
# -- >>------------------------------------------------------------------------------------
drop table if exists goblin_user_coupon;
create table goblin_user_coupon
(
    mid             bigint unsigned auto_increment primary key,
    ucoupon_id      varchar(64)  not null,
    store_coupon_id varchar(64)  not null comment '~goblin_store_coupon.store_coupon_id',
    uid             varchar(64)  not null comment '~adam_user.uid',
    state           tinyint      null comment '用户券状态[1-可用|2-无效|3-已过期|5-已使用]',
    bind_at         datetime(3)  null comment '激活时间',
    dued_at         datetime(3)  null comment '到期时间',
    used_at         datetime(3)  null comment '使用时间',
    used_for        varchar(255) null comment '用于记录购买的内容',
    operator        varchar(64)  null,
    created_at      datetime(3)  not null,
    updated_at      datetime(3)  null,
    comment         text
) engine = InnoDB comment '商城用户券信息';

create unique index uidx_guc_ucoupon_id on goblin_user_coupon (ucoupon_id);
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------
# -- >>------------------------------------------------------------------------------------