package com.liquidnet.service.goblin.service.impl.inner;

import com.liquidnet.commons.lang.util.CollectionUtil;
import com.liquidnet.commons.lang.util.JsonUtils;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.base.SqlMapping;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.galaxy.dto.param.GalaxyArtSeriesClaimResultQueryReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyArtSeriesClaimResultQueryRespDto;
import com.liquidnet.service.galaxy.service.IGalaxyArtworkService;
import com.liquidnet.service.goblin.constant.GoblinRedisConst;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedList;

@Slf4j
@Service
public class GoblinQueBizArtworkClqService {
    @Autowired
    GoblinRedisUtils goblinRedisUtils;
    @Autowired
    GoblinMongoUtils goblinMongoUtils;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    StringRedisTemplate stringRedisTemplate;

    @Resource(name = "galaxyArtworkServiceImpl")
    private IGalaxyArtworkService galaxyArtworkService;

    private static final String SQL_UPDATE_GOODS_SKU_NFT = "UPDATE goblin_goods_sku_nft SET upchain=?,series_id=?,series_hash=?,nft_hash=?,declare_at=?,updated_at=? WHERE sku_id=? ";

    public ResponseDto<String> bizArtworkClqProcessing(String skuId) {
        GoblinGoodsSkuInfoVo mgtGoodsSkuInfoVo = goblinMongoUtils.getGoodsSkuInfoVo(skuId);
        if (null == mgtGoodsSkuInfoVo) {
            log.warn("#NFT声明查询：藏品SKU不存在[skuId={}]", skuId);
            return ResponseDto.success(String.format("藏品SKU不存在[skuId:%s]", skuId));
        }
        int skuType = mgtGoodsSkuInfoVo.getSkuType(), upchain = mgtGoodsSkuInfoVo.getUpchain();
        String unbox = mgtGoodsSkuInfoVo.getUnbox();
        // 非数字藏品 || 盲盒 || 非声明中 || 已有声明系列ID
        if (1 != skuType || !"0".equals(unbox) || 9 != upchain || StringUtils.isNotEmpty(mgtGoodsSkuInfoVo.getSeriesId())) {
            log.warn("#NFT声明查询：藏品SKU无效或已声明[skuId={},skuType={},unbox={},upchain={},seriesId={}]",
                    skuId, skuType, unbox, upchain, mgtGoodsSkuInfoVo.getSeriesId());
            return ResponseDto.success(String.format("藏品SKU无效或已声明[skuId:%s]", skuId));
        }

        GalaxyArtSeriesClaimResultQueryRespDto resultQueryRespDto = this.queryNftSeriesClaimResult(skuId, mgtGoodsSkuInfoVo.getRouteType());
        if (null == resultQueryRespDto) {
            return ResponseDto.failure(String.format("藏品声明查询失败[skuId:%s]", skuId));// 声明查询失败，重新入队处理
        }

        String seriesId = resultQueryRespDto.getSeriesId();
        String txHash = resultQueryRespDto.getTxHash();
        String nftHash = resultQueryRespDto.getNftHash();
        String chainTimestamp = resultQueryRespDto.getChainTimestamp();

        LocalDateTime now = LocalDateTime.now();
        mongoTemplate.getCollection(GoblinGoodsSkuInfoVo.class.getSimpleName()).updateOne(
                Query.query(Criteria.where("skuId").is(skuId).and("delFlg").is("0")).getQueryObject(),
                Update.update("upchain", 1).set("seriesId", seriesId).set("seriesHash", txHash).set("nftHash", nftHash).set("declareAt", chainTimestamp).getUpdateObject()
        );
        goblinRedisUtils.del(GoblinRedisConst.BASIC_GOODS_SKU.concat(skuId));

        // Mysql持久化
        HashMap<String, String> sqlUpdateMap = CollectionUtil.mapStringString();
        LinkedList<String> toMqSqls = CollectionUtil.linkedListString();
        toMqSqls.add(SQL_UPDATE_GOODS_SKU_NFT);
        LinkedList<Object[]> updateGoodsSkuNftObjs = CollectionUtil.linkedListObjectArr();
        updateGoodsSkuNftObjs.add(new Object[]{1, seriesId, txHash, nftHash, chainTimestamp, now, skuId});

        sqlUpdateMap.put(MQConst.QUEUE_MESSAGE_KEY, SqlMapping.gets(toMqSqls, updateGoodsSkuNftObjs));
        stringRedisTemplate.opsForStream().add(StreamRecords.mapBacked(sqlUpdateMap).withStreamKey(MQConst.GoblinQueue.SQL_GOODS.getKey()));
        return ResponseDto.success();
    }

    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */

    private GalaxyArtSeriesClaimResultQueryRespDto queryNftSeriesClaimResult(String skuId, String routerType) {
        GalaxyArtSeriesClaimResultQueryReqDto requestDto = GalaxyArtSeriesClaimResultQueryReqDto.getNew();
        ResponseDto<GalaxyArtSeriesClaimResultQueryRespDto> responseDto = null;
        try {
            requestDto.setSkuId(skuId);
            requestDto.setRouterType(routerType);
            responseDto = galaxyArtworkService.seriesClaimResultQuery(requestDto);
            if (!responseDto.isSuccess()) {
                log.warn("#NFT声明查询:处理失败[paramsStr={},postRespStr={}]", JsonUtils.toJson(requestDto), JsonUtils.toJson(responseDto));
                return null;
            }
            return responseDto.getData();
        } catch (Exception e) {
            log.error("Ex.NFT声明查询:处理异常[paramsStr={},postRespStr={}],ex:{}", JsonUtils.toJson(requestDto), JsonUtils.toJson(responseDto), e.getMessage());
            return null;
        }
    }

    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
    /* ------------------------------------------------------------------------------------ */
}
