package com.liquidnet.service.goblin.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 商铺营销-优惠券
 * </p>
 *
 * @author liquidnet
 * @since 2022-02-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinStoreCoupon implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * 卡券ID
     */
    private String storeCouponId;

    /**
     * 卡券编码
     */
    private String storeCouponNo;

    /**
     * 店铺ID
     */
    private String storeId;

    /**
     * 卡券名称
     */
    private String title;

    /**
     * 标注
     */
    private String label;

    /**
     * 卡券描述
     */
    private String notice;

    /**
     * 券类型[1-代金券|2-折扣券|3-满减券]
     */
    private String type;

    /**
     * 卡券库存，默认：0为无限
     */
    private Integer stock;

    /**
     * 触发金额
     */
    private BigDecimal triggers;

    /**
     * 面值
     */
    private BigDecimal valFace;

    /**
     * 折扣[8折即0.8]
     */
    private BigDecimal discount;

    /**
     * 满减~满
     */
    private BigDecimal valOver;

    /**
     * 满减~减
     */
    private BigDecimal valMinus;

    /**
     * 抵扣上限金额（最多扣除金额）
     */
    private BigDecimal deduction;

    /**
     * 叠加限制[0-限制|1-叠加]
     */
    private String overlay;

    /**
     * #同类别券叠加适用
     */
    private String overlayLevel;

    /**
     * 限领数量，默认：1张/人
     */
    private Integer receiveLimit;

    /**
     * 领取约束[0-不开放|1-开放]
     */
    private String receiveCurb;

    /**
     * 使用范围[0-全部商品|1-部分商品]
     */
    private String useScope;

    /**
     * 卡券状态[0-等待开始|1-活动中|2-活动结束|3-停用]
     */
    private String state;

    /**
     * 开始时间
     */
    private LocalDateTime startTime;

    /**
     * 结束时间
     */
    private LocalDateTime endTime;

    /**
     * 删除标记[0-未删除|1-删除]
     */
    private String delFlg;

    private String createdBy;

    private LocalDateTime createdAt;

    private String updatedBy;

    private LocalDateTime updatedAt;

    private String deletedBy;

    private LocalDateTime deletedAt;

    private String comment;


}
