package com.liquidnet.service.kylin.controller;


import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.service.impl.KylinArActiveServiceImpl;
import com.liquidnet.service.kylin.utils.DataUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 *   ar活动
 * </p>
 *
 */

@Api(tags = "ar活动有关接口")
@RestController
@RequestMapping("arActive")
@Slf4j
public class KylinArActiveController {
    @Autowired
    private KylinArActiveServiceImpl kylinArActiveService;
    @Autowired
    private DataUtils dataUtils;

    @PostMapping("getUserStatus")
    @ApiOperation("查看用户是否绑定(0没有绑定、1绑定了、2失效[目前失效没有用]")
    public ResponseDto<String> getUserStatus() {
        String uid = CurrentUtil.getCurrentUid();
        if(null==dataUtils.getUserStatus(uid)){
            return  ResponseDto.success("0");
        }else{
            return   ResponseDto.success(dataUtils.getUserStatus(uid));
        }
    }
    @PostMapping("exchangeCode")
    @ApiOperation("兑换码兑换")
    public ResponseDto<String> exchangeCode(@RequestParam(value = "code")String code) {
        String uid = CurrentUtil.getCurrentUid();
        return kylinArActiveService.exchange(code.trim(),uid);
    }



}
