package com.liquidnet.service.goblin.dto.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@ApiModel
@Data
public class GoblinStoreOrderListSkuVo implements Cloneable {
    @ApiModelProperty(value = "skuId")
    private String orderSkuId;
    @ApiModelProperty(value = "skuId")
    private String skuId;
    @ApiModelProperty(value = "spu名称")
    private String spuName;
    @ApiModelProperty(value = "sku名称")
    private String skuName;
    @ApiModelProperty(value = "款式")
    private String skuSpecs;
    @ApiModelProperty(value = "图片")
    private String skuImage;
    @ApiModelProperty(value = " 数量")
    private Integer num;
    @ApiModelProperty(value = "订单状态[0-待付款(用户刚下单)|2-代发货(用户付完款 等待商城发货)|3-代收货(商城已经发货 等待用户确认收货)|4-已完成(用户已经确认收货 订单结束)|5-取消订单(用户未付款前取消订单)|6-退款通过(用户已经付款但是商城还未发货，用户发出退款申请，商城同意退款)|7-退货通过(用户已经确认收货后用户发出退货申请，商城同意所有退货申请 ，一个订单可能有多个单品)|61-6的发起状态|71-7的发起状态]")
    private int status;
    @ApiModelProperty(value = "实付价格")
    private BigDecimal skuPriceActual;
    @ApiModelProperty(value = "原价")
    private BigDecimal price;
    @ApiModelProperty(value = "优惠价")
    private BigDecimal priceVoucher;

    private static final GoblinStoreOrderListSkuVo obj = new GoblinStoreOrderListSkuVo();

    public static GoblinStoreOrderListSkuVo getNew() {
        try {
            return (GoblinStoreOrderListSkuVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreOrderListSkuVo();
        }
    }
}
