package com.liquidnet.service.galaxy.dto.vo.mongo;

import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyNftOrderBo
 * @Package com.liquidnet.service.galaxy.dto.bo
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/3/17 11:16
 */
@Data
public class GalaxyNftTradeVo implements Serializable,Cloneable {
    /**
     * 用户Id
     */
    private String userId;
    /**
     * 应用系统购买系列唯一ID
     */
    private String nftId;
    /**
     * nft名字
     */
    private String nftName;
    /**
     * 本地系列唯一名称
     */
    private String seriesName;
    /**
     * 系列的唯一Id
     */
    private String seriesId;
    /**
     * 本地系列唯一编码
     */
    private String seriesCode;
    /**
     * 交易hash
     */
    private String tradeHash;
    /**
     * 交易时间戳
     */
    private String chainTimestamp;

    /**
     * 转出方地址
     */
    private String fromAddress;

    /**
     * 转入方地址
     */
    private String toAddress;

    /**
     * 交易价格
     */
    private Long tradePrice;

    /**
     * 交易类型
     * @return
     */
    private String tradeType;

    /**
     * 路由类型
     */
    private String routerType;

    /**
     * 创建时间
     */
    private String createdAt;
    /**
     * 更新时间
     */
    private String updatedAt;

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }

    private static final GalaxyNftTradeVo obj = new GalaxyNftTradeVo();

    public static GalaxyNftTradeVo getNew() {
        try {
            return (GalaxyNftTradeVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GalaxyNftTradeVo();
        }
    }
}
