package com.liquidnet.service.goblin.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.liquidnet.service.goblin.entity.GoblinNftExSku;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * <p>
 * NFT兑换活动关联SKU表 Mapper 接口
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-04-19
 */

@Repository
public interface GoblinNftExSkuMapper extends BaseMapper<GoblinNftExSku> {

    /**
     * 批量添加兑换活动和sku的关联
     * @param goblinNftExSkus
     * @return
     */
    int addGoblinNftExSkus(@Param("goblinNftExSkus") List<GoblinNftExSku> goblinNftExSkus);

    /**
     * 根据活动ids查询兑换和sku关联信息
     * @param activityIds
     * @return
     */
    List<GoblinNftExSku> selectGoblinNftExSkuByActivityIds(@Param("activityIds")String activityIds);
}
