package com.liquidnet.service.kylin.controller;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.WqTempParam;
import com.liquidnet.service.kylin.dto.vo.WqTempVo;
import com.liquidnet.service.kylin.service.IKylinTempService;
import com.liquidnet.service.kylin.service.impl.KylinPerformancesServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "补偿接口")
@RestController
@RequestMapping("temp")
@Slf4j
public class TempController {

    @Autowired
    private IKylinTempService kylinTempService;

    @PostMapping("tempRedis")
    @ApiOperation("设置需要填写补偿快递信息的订单id")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "orderId", value = "订单id", required = true),
    })
    public ResponseDto<Boolean> setTempRedis(String orderId) {
        return kylinTempService.setWqRedis(orderId);
    }

    @DeleteMapping("tempRedis")
    @ApiOperation("删除需要填写补偿快递信息的订单id")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "orderId", value = "订单id", required = true),
    })
    public ResponseDto<Boolean> delTempRedis(String orderId) {
        return kylinTempService.delWqRedis(orderId);
    }

    @PutMapping("wqExpress")
    @ApiOperation("添加万青订单快递信息")
    public ResponseDto<Boolean> insertWqTempExpress(@RequestBody WqTempParam param) {
        return kylinTempService.insertWqTempExpress(param);
    }

    @GetMapping("wqExpress")
    @ApiOperation("获取万青订单快递信息")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "orderId", value = "订单id", required = true),
    })
    public ResponseDto<WqTempVo> getWqTempVo(String orderId) {
        return kylinTempService.getWqTempExpress(orderId);
    }

    @GetMapping("sendMail")
    @ApiOperation("发货万青订单")
    @ApiImplicitParams({
            @ApiImplicitParam(type = "query", dataType = "String", name = "orderId", value = "订单id", required = true),
            @ApiImplicitParam(type = "query", dataType = "String", name = "mailNo", value = "快递单号", required = true),

    })
    public ResponseDto<Boolean> updateMailNo(String orderId, String mailNo) {
        return kylinTempService.updateMailNo(orderId, mailNo);
    }
}
