package com.liquidnet.service.merchant.service;

import com.liquidnet.service.merchant.constant.MerchantAuthorizationConst;
import com.liquidnet.service.merchant.dto.vo.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class MerchantMongoService {
    @Autowired
    private MongoTemplate mongoTemplate;

    public MerchantFieldsVo getFieldsVoByFieldId(String fieldId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("fieldId").is(fieldId)), MerchantFieldsVo.class, MerchantFieldsVo.class.getSimpleName());
    }

    public List<MerchantFieldAppliesVo> getFieldAppliesVosByUid(String uid) {
        return mongoTemplate.find(Query.query(Criteria.where("uid").is(uid).and("deletedAt").is(null)), MerchantFieldAppliesVo.class, MerchantFieldAppliesVo.class.getSimpleName());
    }

    public MerchantSponsorsVo getSponsorsVoBySponsorId(String sponsorId) {
        return mongoTemplate.findOne(Query.query(Criteria.where("sponsorId").is(sponsorId)), MerchantSponsorsVo.class, MerchantSponsorsVo.class.getSimpleName());
    }

    public List<MerchantSponsorAppliesVo> getSponsorAppliesVosByUid(String uid) {
        return mongoTemplate.find(Query.query(Criteria.where("uid").is(uid).and("deletedAt").is(null)), MerchantSponsorAppliesVo.class, MerchantSponsorAppliesVo.class.getSimpleName());
    }

    public List<MerchantAuthorizationRecordsVo> getAuthorizationRecordsVosByUid(String uid, String performanceId) {
        return mongoTemplate.find(Query.query(Criteria.where("uid").is(uid).and("performanceId").is(performanceId).and("deletedAt").is(null)), MerchantAuthorizationRecordsVo.class, MerchantAuthorizationRecordsVo.class.getSimpleName());
    }

    public List<MerchantAuthorizationRecordsVo> getCheckersAuthorizationRecordsVosByCuid(String cuid, String performanceId) {
        return mongoTemplate.find(Query.query(Criteria.where("uidRole").is(MerchantAuthorizationConst.PerformanceRole.CHECKER.getRole()).and("cuid").is(cuid).and("performanceId").is(performanceId).and("deletedAt").is(null)), MerchantAuthorizationRecordsVo.class, MerchantAuthorizationRecordsVo.class.getSimpleName());
    }
}
