package com.liquidnet.client.admin.web.controller.zhengzai.stone;

import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.annotation.Log;
import com.liquidnet.client.admin.common.core.controller.BaseController;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.core.page.TableDataInfo;
import com.liquidnet.client.admin.zhengzai.stone.service.IItemService;
import com.liquidnet.service.stone.entity.StoneScoreItems;
import com.liquidnet.service.stone.param.StoneItemBuildParam;
import com.liquidnet.service.stone.param.StoneListParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

@Api(tags = "积分物品")
@Controller
@RequestMapping("stone/item")
public class StoneItemController extends BaseController {
    private String prefix = "zhengzai/stone";

    @Value("${liquidnet.client.admin.platformUrl}")
    private String platformUrl;

    @Autowired
    private IItemService iItemService;

    @GetMapping("integralStore")
    @ApiOperation(value = "积分商品:列表View")
    public String integralStore(ModelMap mmap) {
        return prefix + "/integralStore";
    }

    @GetMapping("integralStoreEdit")
    @ApiOperation(value = "积分商品:详情View")
    public String integralStoreEdit (ModelMap mmap) {
        mmap.put("platformUrl", platformUrl);
        return prefix + "/integralStoreEdit";
    }

    @Log(title = "积分商品:列表")
    @ApiOperation(value = "积分商品:列表")
    @PostMapping("list")
    @ResponseBody
    public TableDataInfo list(StoneListParam listParam) {
        PageInfo<StoneScoreItems> result = iItemService.itemList(listParam.getTitle(), listParam.getState(), listParam.getType());
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(0);
        rspData.setRows(result.getList());
        rspData.setTotal(result.getTotal());
        return rspData;
    }

    @Log(title = "积分商品:修改状态")
    @PutMapping("change/status")
    @ApiOperation(value = "积分商品:修改状态")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "itemId", value = "积分物品ID"),
            @ApiImplicitParam(type = "form", required = true, dataType = "Integer", name = "status", value = "状态[-1-删除|1-上架|7-下架]"),
    })
    public AjaxResult status(@RequestParam("itemId") String itemId, @RequestParam("status") Integer status) {
        String result = iItemService.changeStatus(itemId, status);
        return AjaxResult.success(result);
    }

    @Log(title = "积分商品:详情")
    @GetMapping("details")
    @ApiOperation(value = "积分商品:详情")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(type = "form", required = true, dataType = "String", name = "itemId", value = "积分物品ID"),
    })
    public AjaxResult details(@RequestParam("itemId") String itemId) {
        StoneScoreItems result = iItemService.itemDetails(itemId);
        return AjaxResult.success(result);
    }

    @Log(title = "积分商品:创建")
    @PostMapping("")
    @ApiOperation(value = "积分商品:创建")
    @ResponseBody
    public AjaxResult createItem(StoneItemBuildParam param) {
        String result = iItemService.createItem(param);
        return AjaxResult.success(result);
    }

    @Log(title = "积分商品:修改")
    @PutMapping("")
    @ApiOperation(value = "积分商品:修改")
    @ResponseBody
    public AjaxResult updateItem(StoneItemBuildParam param) {
        String result = iItemService.updateItem(param);
        return AjaxResult.success(result);
    }
}
