package com.liquidnet.service.goblin.dto.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.liquidnet.service.goblin.entity.GoblinNftExActivity;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @Author: wll
 * @Description: nft 兑换活动表
 * @Date:Create：in 2022/4/19 2:14 下午
 */

@Data
@EqualsAndHashCode(callSuper = false)
public class GoblinNftExActivityVo implements Serializable,Cloneable {


    private static final long serialVersionUID = 1L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;


    /**
     * 活动id
     */
    private String activityId;

    /**
     * 活动标题
     */
    private String title;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    /**
     * 总数量
     */
    private Integer countNumber;

    /**
     * 使用数量
     */
    private Integer useNumber;

    /**
     * 未使用数量
     */
    private Integer unUseNumber;


    private  final  static GoblinNftExActivityVo obj = new GoblinNftExActivityVo();

    public static GoblinNftExActivityVo getNew(){
        try {
            return  (GoblinNftExActivityVo) obj.clone();
        }catch (CloneNotSupportedException e){
            return new GoblinNftExActivityVo();
        }
    }

    public GoblinNftExActivityVo copy(GoblinNftExActivity goblinNftExActivity){
        if (null == goblinNftExActivity) return this;
        this.setActivityId(goblinNftExActivity.getActivityId());
        this.setTitle(goblinNftExActivity.getTitle());
        this.setCreatedAt(goblinNftExActivity.getCreatedAt());
        this.setUpdatedAt(goblinNftExActivity.getUpdatedAt());
        return this;
    }

}


