package com.liquidnet.service.sweet.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 数字藏品预约活动表
 * </p>
 *
 * @author jiangxiulong
 * @since 2022-01-18
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class SweetCollectionReservation implements Serializable, Cloneable {

    private static final long serialVersionUID = -4190431204108686647L;

    @TableId(value = "mid", type = IdType.AUTO)
    private Long mid;

    /**
     * reservation_id
     */
    private String reservationId;

    /**
     * 称呼
     */
    private String nickname;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String mailbox;

    /**
     * 企业名称
     */
    private String enterpriseName;

    /**
     * 职务
     */
    private String title;

    /**
     * 创建时间
     */
    private LocalDateTime createdAt;

    /**
     * 更新时间
     */
    private LocalDateTime updatedAt;

    private static final SweetCollectionReservation obj = new SweetCollectionReservation();
    public static SweetCollectionReservation getNew() {
        try {
            return (SweetCollectionReservation) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetCollectionReservation();
        }
    }


}
