package com.liquidnet.service.goblin.constant;

public class GoblinRedisConst {
    public static final String PREFIX = "goblin:";
    /* ----------------------------------------------------------------- */
    /**
     * IOS商品价格集
     * {goblin:bsc:lib:ios_products, JsonNode}
     */
    public static final String BASIC_LIB_IOS_PRODUCTS = PREFIX.concat("bsc:lib:ios_products");
    /**
     * 认证中店铺UID关系缓存
     * {goblin:bsc:ustore:${uid}, List<store_id>}
     */
    public static final String BASIC_USTORE = PREFIX.concat("bsc:ustore:");
    /**
     * 平台商品标签信息
     * {goblin:bsc:self_tag, JsonUtils.toJson(List<com.liquidnet.service.goblin.dto.vo.GoblinSelfTagVo>)}
     */
    public static final String BASIC_SELF_TAG = PREFIX.concat("bsc:self_tag");
    /**
     * 平台专属标签信息
     * {goblin:bsc:self_etag, JsonUtils.toJson(List<com.liquidnet.service.goblin.dto.vo.GoblinSelfTagVo>)}
     */
    public static final String BASIC_SELF_EXTAG = PREFIX.concat("bsc:self_etag");
    /**
     * 平台商品分类信息
     * {goblin:bsc:self_g_c, JsonUtils.toJson(List<com.liquidnet.service.goblin.dto.vo.GoblinSelfGoodsCategoryVo>)}
     */
    public static final String BASIC_SELF_GOODS_CATEGORY = PREFIX.concat("bsc:self_g_c");
    /**
     * 平台商品分类信息
     * {goblin:bsc:self_g_c_s:${cate_id}, com.liquidnet.service.goblin.dto.manage.vo.GoblinMgtCategorySpecVo}
     */
    public static final String BASIC_SELF_GOODS_CATEGORY_SPEC = PREFIX.concat("bsc:self_g_c_s:");
    /**
     * 平台服务支持信息
     * {goblin:bsc:sev_sup, JsonUtils.toJson(List<com.liquidnet.service.goblin.dto.vo.GoblinServiceSupportVo>)}
     */
    public static final String BASIC_SERVICE_SUPPORT = PREFIX.concat("bsc:sev_sup");
    /**
     * 店铺信息
     * {goblin:bsc:store:${store_id}, com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo}
     */
    public static final String BASIC_STORE = PREFIX.concat("bsc:store:");
    /**
     * 店铺配置信息
     * {goblin:bsc:store_cf:${store_id}, com.liquidnet.service.goblin.dto.vo.GoblinStoreInfoVo}
     */
    public static final String BASIC_STORE_CONF = PREFIX.concat("bsc:store_cf:");
    /**
     * 店铺商品分类信息
     * {goblin:bsc:store_g_c:${store_id}, JsonUtils.toJson(List<com.liquidnet.service.goblin.dto.vo.GoblinStoreGoodsCategoryVo>)}
     */
    public static final String BASIC_STORE_GOODS_CATEGORY = PREFIX.concat("bsc:store_g_c:");
    /**
     * SPU信息
     * {goblin:bsc:goods:${spu_id}, com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo}
     */
    public static final String BASIC_GOODS = PREFIX.concat("bsc:goods:");
    public static final String BASIC_GOODS_UNSHELVES = PREFIX.concat("bsc:goods_unshelves:");
    /**
     * SKU信息
     * {goblin:bsc:goods_sku:${sku_id}, com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo}
     */
    public static final String BASIC_GOODS_SKU = PREFIX.concat("bsc:goods_sku:");
    public static final String BASIC_GOODS_SKU_UNSHELVES = PREFIX.concat("bsc:goods_sku_unshelves:");

    /* ----------------------------------------------------------------- */

    /**
     * 店铺公告
     * {goblin:store_ntc:${store_id}, com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo}
     */
    public static final String STORE_NOTICE = PREFIX.concat("store_ntc:");

    /* ----------------------------------------------------------------- */
    public static final String FRONT_TOP_BANNER = PREFIX.concat("front_top_banner");  //前端顶部banner
    public static final String FRONT_MIDDLE_BANNER = PREFIX.concat("front_middle_banner");  //前端中部banner
    public static final String FRONT_NAVIGATION = PREFIX.concat("front_navigation");  //前端banner
    public static final String FRONT_HOTWORD = PREFIX.concat("front_hot_word");  //前端banner
    public static final String FRONT_HOTWORD_INDEX = PREFIX.concat("front_hot_word_index");  //前端banner index
    public static final String FRONT_FRONT_SECKILL = PREFIX.concat("front_front_seckill");  //前端 首页秒杀
    public static final String FRONT_SECKILL = PREFIX.concat("front_seckill");  //前端 秒杀列表
    public static final String SELECT_GOODS = PREFIX.concat("select_goods");  //配置的精选商品
    public static final String SELECT_GOODS_PAGE1 = PREFIX.concat("select_goods_page1");  //精选商品 第一页
    public static final String SELECT_GOODS_SORT = PREFIX.concat("select_goods_sort");  //精选商品 排序规则
    public static final String SELECT_GOODS_SPUIDS = PREFIX.concat("select_goods_SPUIDS");  //精选商品 spuids
    public static final String SELECT_GOODS_SPUIDS_ISHAVE = PREFIX.concat("select_goods_SPUIDS_isHave");  //精选商品 spuids
    public static final String MOUDLE_INDEX = PREFIX.concat("moudle_index");  //moudle_index 组件排序
    public static final String COMPLIATIONS = PREFIX.concat("goblinFrontCompilations");  // 合集
    public static final String FRONT_GOBLINFRONTCUBE = PREFIX.concat("goblinFrontCube");  // 魔方
    public static final String FRONT_GOBLIN_RECOMMEND = PREFIX.concat("goblinFrontRECOMMMEND");  // 新品推荐
    public static final String FRONT_SHOPCART = PREFIX.concat("goblin_shopcart:");  // 购物车
    public static final String FRONT_SHOPCART_TWO = PREFIX.concat("goblin_shopcartTwo:");  // 购物车第二部


    /* ----------------------------------------------------------------- */
    public static final String REDIS_GOBLIN_MARKET_RELATION = PREFIX.concat("market:relation:");//商铺活动-商铺款式关联关系
    public static final String REDIS_GOBLIN_SELF_MARKET = PREFIX.concat("self:market:");//官方活动
    public static final String REDIS_GOBLIN_ZHENGZAI_RELATION = PREFIX.concat("zhengzai:market:");//活动-正在下单-可参加商户
    public static final String REDIS_GOBLIN_STORE_SELF_RELATION = PREFIX.concat("zhengzai:storeId:");//活动-当前商铺能参与的官方活动id列表
    public static final String REDIS_GOBLIN_STORE_MARKET = PREFIX.concat("store:market:");//商铺活动
    public static final String REDIS_GOBLIN_ZHENGZAI_LIST = PREFIX.concat("zhengzai:list");//全部正在下单内容

    public static final String REDIS_GOBLIN_STORE_MARKET_ISCONFIG = PREFIX.concat("store:is_config:");//商铺活动-该活动配置了款式的商品

    public static final String REDIS_GOBLIN_BUY_COUNT = PREFIX.concat("uid:");//用户sku购买数量 key:uid:skuId:$skuId
    public static final String REDIS_GOBLIN_SALE_COUNT = PREFIX.concat("sale:skuId:");//用户sku购买数量 key:sale:skuId:$skuId
    public static final String REDIS_GOBLIN_SALE_SPU_COUNT = PREFIX.concat("sale:spuId:");//用户sku购买数量 key:sale:skuId:$spuId
    public static final String REDIS_GOBLIN_ORDER = PREFIX.concat("order:");//用户sku购买数量 key:$orderId
    public static final String REDIS_GOBLIN_ORDER_BACK = PREFIX.concat("order:back:");//用户sku购买数量 key:$backOrderId
    public static final String REDIS_GOBLIN_ORDER_SKU = PREFIX.concat("orderSku:");//用户sku购买数量 key:$orderSkuId
    public static final String REDIS_GOBLIN_ORDER_UN_PAY = PREFIX.concat("order:un:pay:");//未支付订单id列表 key:$randomKey
    public static final String REDIS_GOBLIN_ORDER_LIST = PREFIX.concat("order:id:list:");//用户订单id列表 key:$uid
    public static final String REDIS_GOBLIN_ORDER_ZHENGZAI_LIST = PREFIX.concat("order:zhengzai:list:");//用户订单id列表 key:$uid
    public static final String REDIS_GOBLIN_ORDER_MASTER = PREFIX.concat("order:masterCode:");//用户订单id列表 key:$masterCode
    public static final String REDIS_GOBLIN_ORDER_OFFCODE = PREFIX.concat("order:offCode:");//用户订单id列表 key:$wtrieOffCode
    public static final String REDIS_GOBLIN_BACK_ORDER_ID = PREFIX.concat("order:backIds:");//用户订单下的退款订单id key:$orderId
    public static final String REDIS_CAN_BUY = PREFIX.concat("canBuy:");//可以购买的用户 key:$skuId:$mobile
    public static final String REDIS_ZZ_MUSIC_TAG = PREFIX.concat("music:tag:ZZ:");//根据场次音乐人标签搜索列表 key:$musicTag:$performanceId
    public static final String REDIS_GOBLIN_MAIL = PREFIX.concat("mail:orderId:");//快递 $key:$orderId
    public static final String REDIS_GOBLIN_TEMP_COUPON_MARKET = PREFIX.concat("temp:coupon:marketId:");//id 列表 $key:$marketId
    public static final String REDIS_GOBLIN_TEMP_COUPON = PREFIX.concat("temp:coupon:");//详情 $key:$ucouponId

    /* --------------------------------NFT--------------------------------- */
    public static final String REDIS_GOBLIN_NFT_ORDER_INFO = PREFIX.concat("nftOrder:");// nft订单详情 orderId
    public static final String REDIS_GOBLIN_NFT_ORDER_ID_OF_CODE = PREFIX.concat("nftOrder:orderCode:");// nft订单ID获取 orderCode
    public static final String REDIS_GOBLIN_NFT_ORDER_USER_ID_LIST = PREFIX.concat("nftOrder:idList:user:");// nft用户订单id列表 userId
    public static final String REDIS_GOBLIN_NFT_ORDER_REFUND_INFO = PREFIX.concat("nftOrder:refund:");// nft退款订单详情 orderId
    public static final String REDIS_GOBLIN_NFT_ORDER_BUG_LOCK = PREFIX.concat("nftOrder:lock:userId:");// nft购买用户锁 userId
    public static final String REDIS_GOBLIN_NFT_GOODS_LIST = PREFIX.concat("nftGoodsList");// nft商品列表
    public static final String REDIS_GOBLIN_NFT_NUM_ACCOUNT = PREFIX.concat("nftNumAccount:");// nft用户数字账户是否开通 userId



    /* ----------------------------------------------------------------- */
    /**
     * SKU剩余库存
     */
    public static final String REAL_STOCK_SKU = PREFIX.concat("real_stock_sku:");
    public static final String SKU_RELATION = PREFIX.concat("sku:relation:");//$key:$skuId
    /* ----------------------------------------------------------------- */

    /**
     * 商铺活动:优惠券基本信息
     * {goblin:s_coupon:${store_coupon_id}, com.liquidnet.service.goblin.dto.vo.GoblinStoreCouponVo}
     */
    public static final String STORE_COUPON = PREFIX.concat("s_coupon:");
    /**
     * 商铺活动:优惠券适用商品ID集合
     * {goblin:s_coupon_r:${store_coupon_id}, JsonUtils.toJson(List<String:spu_id>)}
     */
    public static final String STORE_COUPON_RULE = PREFIX.concat("s_coupon_r:");
    /**
     * 商铺活动:优惠券剩余库存
     */
    public static final String STORE_COUPON_STOCK = PREFIX.concat("s_coupon_stock:");

    /* ----------------------------------------------------------------- */

    /**
     * 商铺活动ID集合
     * {goblin:store_markets:${store_id}, JsonUtils.toJson(List<com.liquidnet.service.goblin.dto.GoblinGoodsMarketDto>)}
     */
    public static final String STORE_MARKETS = PREFIX.concat("store_markets:");

    /* ----------------------------------------------------------------- */

    /**
     * 商城用户券
     * {golblin:user_coupon:${uid}, JsonUtils.toJson(List<com.liquidnet.service.goblin.dto.vo.GoblinUserCouponVo>)}
     */
    public static final String USER_COUPON = PREFIX.concat("user_coupon:");

    /* ----------------------------------------------------------------- */

    /**
     * 我的藏品ID列表（首页）
     * {goblin:u_d_art:${uid}, JsonUtils.toJson(List<String:artwork_id>)}
     */
    public static final String USER_DIGITAL_ARTWORK_IDS = PREFIX.concat("u_d_art_ids:");

    /**
     * 我的藏品信息
     * {goblin:u_d_art:${artwork_id}, JsonUtils.toJson(com.liquidnet.service.goblin.dto.vo.GoblinDigitalArtworkVo)}
     */
    public static final String USER_DIGITAL_ARTWORK = PREFIX.concat("u_d_art:");

    /**
     * 我的藏品计数
     * {goblin:u_d_art_ct:${uid}, count(1)}
     */
    public static final String USER_DIGITAL_ARTWORK_CT = PREFIX.concat("u_d_art_ct:");

    /**
     * 藏品盲盒开启标记
     * {goblin:u_d_art_ub:${artworkId}, Number}
     */
    public static final String USER_DIGITAL_ARTWORK_UNBOX = PREFIX.concat("u_d_art_ub:");

    /**
     * 我的藏品生成标记（有时效）
     * {goblin:u_d_art:${uid+skuId+orderId},1}
     */
    public static final String USER_DIGITAL_ARTWORK_GENMARK = PREFIX.concat("u_d_art_gm:");

    /* ----------------------------------------------------------------- */

    /**
     * 用户预约标识
     * {goblin:user:anticipate:${skuId}:${uid},(goblin_goods_anticipate_user)}
     */
    public static final String USER_ANTICIPATE_STATE = PREFIX.concat("user:anticipate:");

    /**
     * 真实预约人数
     * {goblin:anticipate:people:${autId},numPeople}
     */
    public static final String ANTICIPATE_PEOPLE = PREFIX.concat("anticipate:people:");

    /**
     * 记录sku
     */
    public static final String ANTICIPATE_SKUID = PREFIX.concat("anticipate:skuId:");




    /* ----------------------------------------------------------------- */
    /* ----------------------------------------------------------------- */
}
