package com.liquidnet.service.goblin.service.manage;

import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.goblin.dto.manage.GoblinStoreMgtNoticeFilterParam;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreNoticeVo;

import java.util.List;

public interface IGoblinStoreMgtNoticeService {
    /**
     * 店铺管理:公告通知:列表
     *
     * @param filterParam GoblinStoreMgtNoticeFilterParam
     * @return PagedResult<GoblinStoreNoticeVo>
     */
    PagedResult<GoblinStoreNoticeVo> pageList(GoblinStoreMgtNoticeFilterParam filterParam);

    /**
     * 店铺管理:公告通知:添加
     *
     * @param storeNoticeVo GoblinStoreNoticeVo
     */
    void addSave(GoblinStoreNoticeVo storeNoticeVo);

    /**
     * 店铺管理:公告通知:编辑
     *
     * @param updateStoreNoticeVo GoblinStoreNoticeVo
     * @return boolean
     */
    boolean editSave(GoblinStoreNoticeVo updateStoreNoticeVo);

    /**
     * 店铺管理:公告通知:发布
     *
     * @param uid          UID
     * @param storeId      店铺ID
     * @param noticeIdList List<String>
     * @return boolean
     */
    boolean releaseProcessing(String uid, String storeId, List<String> noticeIdList);

    /**
     * 店铺管理:公告通知:删除
     *
     * @param uid          UID
     * @param storeId      店铺ID
     * @param noticeIdList List<String>
     * @return boolean
     */
    boolean removeProcessing(String uid, String storeId, List<String> noticeIdList);
}
