package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

@ApiModel(value = "GoblinStoreGoodsCategoryVo", description = "店铺商品分类")
@Data
public class GoblinStoreGoodsCategoryVo implements Serializable, Cloneable {
    private static final long serialVersionUID = -9043528667634548144L;
    @ApiModelProperty(position = 11, value = "店铺ID")
    private String storeId;
    @ApiModelProperty(position = 12, value = "分类ID")
    private String cateId;
    @ApiModelProperty(position = 13, value = "分类名称")
    private String name;
    @ApiModelProperty(position = 14, value = "排序[数值越小,排序越前]")
    private Integer sort;
    @ApiModelProperty(position = 15, value = "分类层级[1-一级|2-二级|3-三级]")
    private String grade;
    @ApiModelProperty(position = 16, value = "父级分类ID")
    private String catePid;
    @ApiModelProperty(position = 17, value = "是否需要填写ISBN[0-否|1-是]")
    private String neIsbn;
    @ApiModelProperty(position = 18, value = "删除标记[0-未删除|1-删除]")
    private String delFlg;

    private String createdBy;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;
    private String updatedBy;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;
    private String deletedBy;
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern= DateUtil.DATE_FULL_STR)
    private LocalDateTime deletedAt;

    private static final GoblinStoreGoodsCategoryVo obj = new GoblinStoreGoodsCategoryVo();

    public static GoblinStoreGoodsCategoryVo getNew() {
        try {
            return (GoblinStoreGoodsCategoryVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreGoodsCategoryVo();
        }
    }

    public GoblinStoreGoodsCategoryVo copy(GoblinSelfGoodsCategoryVo source) {
        if (null == source) return this;
        this.setCateId(source.getCateId());
        this.setName(source.getName());
        this.setSort(source.getSort());
        this.setGrade(source.getGrade());
        this.setCatePid(source.getCatePid());
        this.setNeIsbn(source.getNeIsbn());
        return this;
    }
}
