package com.liquidnet.service.goblin.dto.manage.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.manage.GoblinGoodsAnticipateValueAddParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigInteger;
import java.time.LocalDateTime;

/**
 * <p>
 * 预约关联sku和spu表
 * </p>
 *
 * @author liquidnet
 * @since 2022-04-08
 */
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinGoodsAnticipateValueVo implements Cloneable {

    private static final long serialVersionUID = 1L;

    /**
     * uid
     */
    @ApiModelProperty(value = "uid")
    private String uid;

    /**
     * antId
     */
    @ApiModelProperty(value = "antId")
    private String antId;

    /**
     * sku名称
     */
    @ApiModelProperty(value = "sku名称")
    private String skuName;

    /**
     * sku_id 对应 goblin_goods_sku.sku_id
     */
    @ApiModelProperty(value = "sku_id 对应 goblin_goods_sku.sku_id")
    private String skuId;

    /**
     * spu_id对应 goblin_goods_spu_id
     */
    @ApiModelProperty(value = "spu_id对应 goblin_goods_spu_id")
    private String spuId;

    @ApiModelProperty("预约人数")
    private BigInteger aboutPeople;

    @ApiModelProperty("实际预约人数")
    private BigInteger actualPeople;

    @ApiModelProperty("预约规则")
    private String rule;

    /**
     * 预约开始时间
     */
    @ApiModelProperty(value = "预约开始时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime aboutStartDate;

    /**
     * 预约结束时间
     */
    @ApiModelProperty(value = "预约结束时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime aboutEndDate;

    @ApiModelProperty("预约状态")
    private Integer state;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdDate;

    /**
     * 修改时间
     */
    @ApiModelProperty(value = "修改时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updateDate;

    /**
     * 删除（0:未删除1:已删除）
     */
    @ApiModelProperty(value = "删除（0:未删除1:已删除）")
    private Integer delTag;
    @ApiModelProperty("预约类型（1：预约提醒，2：预约获得购买资格）")
    private Integer type;
    @ApiModelProperty("设置预约人数")
    private Integer peopleType;

    private static final GoblinGoodsAnticipateValueVo obj = new GoblinGoodsAnticipateValueVo();

    public static GoblinGoodsAnticipateValueVo getNew() {
        try {
            return (GoblinGoodsAnticipateValueVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinGoodsAnticipateValueVo();
        }
    }

    public GoblinGoodsAnticipateValueVo copy(GoblinGoodsAnticipateValueAddParam goodsAnticipateValueAddParam) {
        if (null == goodsAnticipateValueAddParam) return this;
        this.setSkuName(goodsAnticipateValueAddParam.getSkuName());
        this.setSkuId(goodsAnticipateValueAddParam.getSkuId());
        this.setSpuId(goodsAnticipateValueAddParam.getSpuId());
        this.setAboutStartDate(goodsAnticipateValueAddParam.getAboutStartDate());
        this.setAboutEndDate(goodsAnticipateValueAddParam.getAboutEndDate());
        return this;
    }


}
