package com.liquidnet.service.goblin.controller.manage;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinServiceSupportVo;
import com.liquidnet.service.goblin.service.manage.IGoblinMgtServiceSupportService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@ApiSupport(order = 149003)
@Api(tags = "服务支持管理")
@Slf4j
@Validated
@RestController
@RequestMapping("mgt/sevs")
public class GoblinMgtServiceSupportController {
    @Autowired
    IGoblinMgtServiceSupportService goblinMgtServiceSupportService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "服务支持列表")
    @PostMapping("list")
    public ResponseDto<List<GoblinServiceSupportVo>> list() {
        return ResponseDto.success(goblinMgtServiceSupportService.list());
    }
}
