package com.liquidnet.service.goblin.controller.manage;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinStoreGoodsCategoryVo;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order = 149003)
@Api(tags = "店铺分类管理")
@Slf4j
@Validated
@RestController
@RequestMapping("store/mgt/category")
public class GoblinStoreMgtCategoryController {
    @Autowired
    GoblinMongoUtils goblinMongoUtils;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "列表")
    @GetMapping("list")
    public ResponseDto<PagedResult<GoblinStoreGoodsCategoryVo>> list() {
        return ResponseDto.success(null);
    }
}
