package com.liquidnet.common.third.zxlnft.dto;

import com.liquidnet.common.third.zxlnft.dto.nft.Nft032SeriesResp;
import com.liquidnet.commons.lang.util.JsonUtils;
import lombok.Data;

import java.io.Serializable;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: SeriesReq
 * @Package com.liquidnet.common.third.zxlnft.dto.nft
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/2/18 15:44
 */
@Data
public class Nft032SeriesRespDto implements Serializable {
    private Nft032SeriesResp.SeriesInfo seriesInfo;

    @Data
    public class SeriesInfo{
        /**
         * 系列ID
         */
        private String seriesId;
        /**
         * 系列名字
         */
        private String name;
        /**
         * 创建者地址
         */
        private String creatorAddr;
        /**
         * 总数
         */
        private String totalCount;
        /**
         * 系列下的nftId后缀,是否从0开始，true就是从0开始，默认为false，从1开始
         */
        private String seriesBeginFromZero;
        /**
         * 当前个数（当前已发行此系列的个数）
         */
        private String crtCount;
        /**
         * 封面图
         */
        private String coverUrl;
        /**
         * 描述
         */
        private String desc;
        /**
         * 创建时间戳
         */
        private String createTimeStamp;
    }

    private static final Nft032SeriesRespDto obj = new Nft032SeriesRespDto();
    public static Nft032SeriesRespDto getNew() {
        try {
            return (Nft032SeriesRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Nft032SeriesRespDto();
        }
    }

    @Override
    public String toString(){
        return JsonUtils.toJson(this);
    }
}
