package com.liquidnet.service.galaxy.router.zxin.biz;

import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.dto.Nft037AddressListReqDto;
import com.liquidnet.common.third.zxlnft.dto.Nft037AddressListRespDto;
import com.liquidnet.common.third.zxlnft.dto.ZxlnftResponseDto;
import com.liquidnet.common.third.zxlnft.util.ZxlWalletSdkUtil;
import com.liquidnet.common.third.zxlnft.util.ZxlnftSdkUtil;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.dto.bo.GalaxyUserInfoBo;
import com.liquidnet.service.galaxy.dto.param.GalaxyQueryNftListReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyQueryNftListRespDto;
import com.liquidnet.service.galaxy.utils.GalaxyDataUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxinTradeQueryBiz
 * @Package com.liquidnet.service.galaxy.router.zxin.biz
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/7 17:38
 */
@Slf4j
@Component
public class ZxinTradeQueryBiz {
    @Autowired
    private ZxlnftSdkUtil zxlnftSdkUtil;

    @Autowired
    private ZxlWalletSdkUtil zxlWalletSdkUtil;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    @Autowired
    private GalaxyDataUtils dataUtils;

    public ResponseDto<GalaxyQueryNftListRespDto> nftList(GalaxyQueryNftListReqDto reqDto) {
        //获取用户信息
        GalaxyUserInfoBo userInfoBo = dataUtils.getGalaxyUserInfo(reqDto.getRouterType(),reqDto.getUserId());

        Nft037AddressListReqDto nft037ReqDto = Nft037AddressListReqDto.getNew();
        nft037ReqDto.setAddr(userInfoBo.getBlockChainAddress());
        nft037ReqDto.setSeriesId(reqDto.getSeriesId());
        nft037ReqDto.setLimit(1000l);
        ZxlnftResponseDto<Nft037AddressListRespDto> zxlnftResponseDto = zxlnftSdkUtil.nft037AddressList(nft037ReqDto);


        GalaxyQueryNftListRespDto queryNftListRespDto = GalaxyQueryNftListRespDto.getNew();
        if(zxlnftResponseDto.isSuccess()){
            BeanUtil.copy(zxlnftResponseDto.getData(),queryNftListRespDto);
            queryNftListRespDto.setUserId(reqDto.getUserId());
            queryNftListRespDto.setSeriesId(reqDto.getSeriesId());
        }else{
            return ResponseDto.failure();
        }
        return ResponseDto.success(queryNftListRespDto);
    }
}
