package com.liquidnet.service.galaxy.service.impl;

import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyQueryNftListReqDto;
import com.liquidnet.service.galaxy.dto.param.GalaxyQueryNftListRespDto;
import com.liquidnet.service.galaxy.router.strategy.GalaxyRouterStrategyContext;
import com.liquidnet.service.galaxy.service.IGalaxyTradeQueryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: GalaxyUserServiceImpl
 * @Package com.liquidnet.service.galaxy.service.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2022/4/7 12:09
 */
@Slf4j
@Service("galaxyTradeQueryService")
public class GalaxyTradeQueryServiceImpl implements IGalaxyTradeQueryService {
    @Autowired
    private GalaxyRouterStrategyContext galaxyRouterStrategyContext;

    @Override
    public ResponseDto<GalaxyQueryNftListRespDto> nftList(GalaxyQueryNftListReqDto reqDto) {
        return galaxyRouterStrategyContext.getTradeQueryStrategy(reqDto.getRouterType()).nftList(reqDto);
    }
}
