package com.liquidnet.service.adam.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 会员价格
 */
@ApiModel(value = "AdamMemberPriceParam", description = "添加编辑会员价格")
@Data
public class AdamMemberPriceParam implements Serializable {
    private static final long serialVersionUID = -6432796310264973696L;
    @ApiModelProperty(position = 0, required = false, value = "价格id")
    private Integer mid;
    @ApiModelProperty(position = 1, required = false, value = "会员价格ID")
    private String memberPriceId;
    @ApiModelProperty(position = 2, required = false, value = "会员类型ID")
    private String memberId;
    @ApiModelProperty(position = 3, required = false, value = "状态0 不可用 1上线中 2已下线", allowableValues = "0,1,2")
    private Integer status;
    @ApiModelProperty(position = 4, required = false, value = "会员价格包名称", example = "年卡")
    private String name;
    @ApiModelProperty(position = 5, required = false, value = "原价", example = "199")
    private BigDecimal price;
    @ApiModelProperty(position = 6, required = false, value = "折扣价", example = "199")
    private BigDecimal priceFixed;
    @ApiModelProperty(position = 7, required = false, value = "会员包有效天数", example = "365")
    private Integer days;
    @ApiModelProperty(position = 8, required = false, value = "会员包须知", example = "会员包须知")
    private String detail;
}
