package com.liquidnet.client.admin.zhengzai.kylin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.common.utils.StringUtils;
import com.liquidnet.commons.lang.util.BeanUtil;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.kylin.constant.KylinTableStatusConst;
import com.liquidnet.service.kylin.dao.OrderTicketsListDao;
import com.liquidnet.service.kylin.dto.param.admin.OrderListReq;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketEntitiesVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinOrderTicketVo;
import com.liquidnet.service.kylin.dto.vo.mongo.KylinPerformanceVo;
import com.liquidnet.service.kylin.dto.vo.middle.KylinTicketVo;
import com.liquidnet.service.kylin.dto.vo.returns.OrderDetailsVo;
import com.liquidnet.service.kylin.entity.*;
import com.liquidnet.service.kylin.mapper.*;
import com.liquidnet.service.kylin.service.admin.IKylinOrderTicketsAdminService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: KylinOrderTicketsAdminServiceImpl
 * @Package com.liquidnet.client.admin.zhengzai.kylin.service.impl
 * @Copyright: LightNet @ Copyright (c) 2021
 * @date 2021/6/6 12:01
 */
@Slf4j
@Service
public class KylinOrderTicketsAdminServiceImpl extends ServiceImpl<KylinOrderTicketsMapper, KylinOrderTickets> implements IKylinOrderTicketsAdminService {

    @Autowired
    private KylinOrderTicketsMapper kylinOrderTicketsMapper;

    @Autowired
    private KylinOrderTicketRelationsMapper kylinOrderTicketRelationsMapper;

    @Autowired
    private KylinPerformancesMapper kylinPerformancesMapper;

    @Autowired
    private KylinTicketsMapper kylinTicketsMapper;

    @Autowired
    private KylinOrderTicketEntitiesMapper kylinOrderTicketEntitiesMapper;

    @Autowired
    private ExpressesMapper expressesMapper;

    @Override
    public List<OrderTicketsListDao> orderList(OrderListReq orderListReq) {
        HashMap<String, Object> map = new HashMap<>();
        map.put("title", "");
        List<OrderTicketsListDao> list = kylinOrderTicketsMapper.orderList(map);
        return list;
    }

    @Override
    public OrderDetailsVo orderDetails(String orderId) {
        OrderDetailsVo vo = new OrderDetailsVo();
        try {
            //查询条件
            LambdaQueryWrapper<KylinOrderTickets> wrapper = new LambdaQueryWrapper<>();
            if (StringUtils.isNotNull(orderId)) {
                wrapper.eq(KylinOrderTickets::getOrderTicketsId,orderId);
            }
            KylinOrderTicketVo orderTicketVo = new KylinOrderTicketVo();
            KylinOrderTickets kylinOrderTickets = kylinOrderTicketsMapper.selectOne(wrapper);
            //获取订单关联关系
            LambdaQueryWrapper<KylinOrderTicketRelations> relWrapper = new LambdaQueryWrapper<>();
            if (StringUtils.isNotNull(orderId)) {
                relWrapper.eq(KylinOrderTicketRelations::getOrderId,orderId);
            }
            KylinOrderTicketRelations  kylinOrderTicketRelations = kylinOrderTicketRelationsMapper.selectOne(relWrapper);
            BeanUtil.copy(kylinOrderTickets,orderTicketVo);
            orderTicketVo.setPerformanceId(kylinOrderTicketRelations.getPerformanceId());
            orderTicketVo.setTicketId(kylinOrderTicketRelations.getTicketId());
            if (null != orderTicketVo) {
                Expresses expresses = expressesMapper.selectOne(new UpdateWrapper<Expresses>().eq("order_id", orderId).eq("order_type", "order_ticket"));
                //获取演出信息
                LambdaQueryWrapper<KylinPerformances> perWrapper = new LambdaQueryWrapper<>();
                if (StringUtils.isNotNull(orderTicketVo.getPerformanceId())) {
                    perWrapper.eq(KylinPerformances::getPerformancesId,orderTicketVo.getPerformanceId());
                }
                KylinPerformances kylinPerformances = kylinPerformancesMapper.selectOne(perWrapper);
                KylinPerformanceVo performanceVo = new KylinPerformanceVo();
                BeanUtil.copy(kylinPerformances,performanceVo);
                //获取票种信息
                LambdaQueryWrapper<KylinTickets> ticketsWrapper = new LambdaQueryWrapper<>();
                if (StringUtils.isNotNull(orderTicketVo.getTicketId())) {
                    ticketsWrapper.eq(KylinTickets::getTicketsId,orderTicketVo.getTicketId());
                }
                KylinTickets kylinTickets = kylinTicketsMapper.selectOne(ticketsWrapper);
                KylinTicketVo ticketVo = new KylinTicketVo();
                BeanUtil.copy(kylinTickets,ticketVo);

                //获取订单持票实体信息
                LambdaQueryWrapper<KylinOrderTicketEntities> ticketsEntitiesWrapper = new LambdaQueryWrapper<>();
                if (StringUtils.isNotNull(orderTicketVo.getOrderTicketsId())) {
                    ticketsEntitiesWrapper.eq(KylinOrderTicketEntities::getOrderId,orderTicketVo.getOrderTicketsId());
                }
                List<KylinOrderTicketEntitiesVo> kylinOrderTicketEntitiesVoList = new ArrayList<>();
                List<KylinOrderTicketEntities> ticketEntitiesList = kylinOrderTicketEntitiesMapper.selectList(ticketsEntitiesWrapper);
                for (KylinOrderTicketEntities kylinOrderTicketEntities : ticketEntitiesList) {
                    KylinOrderTicketEntitiesVo ticketEntitiesVo = new KylinOrderTicketEntitiesVo();
                    BeanUtil.copy(kylinOrderTicketEntities,ticketEntitiesVo);
                    kylinOrderTicketEntitiesVoList.add(ticketEntitiesVo);
                }

                // 数据脱敏
                for (KylinOrderTicketEntitiesVo item : kylinOrderTicketEntitiesVoList) {
                    if (item.getEnterIdCode().length() == 18) {
                        item.setEnterIdCode(item.getEnterIdCode().substring(0, 3) + "*************" + item.getEnterIdCode().substring(16));
                    }
                    if (item.getEnterMobile().length() == 11) {
                        item.setEnterMobile(item.getEnterMobile().substring(0, 3) + "****" + item.getEnterMobile().substring(7));
                    }
                }
                //计算 倒计时
                if (orderTicketVo.getStatus() == KylinTableStatusConst.ORDER_STATUS0) {
                    vo.setRestTime(DateUtil.intervalSeconds(
                            DateUtil.parse(orderTicketVo.getOverdueAt(), "yyyy-MM-dd HH:mm:ss"),
                            DateUtil.parse(DateUtil.getNowTime(), "yyyy-MM-dd HH:mm:ss")
                    ));
                } else {
                    vo.setRestTime(0L);
                }
                //快递
                if (null != expresses) {
                    vo.setExpress_number(expresses.getNumber());
                    vo.setExpress_company(expresses.getName());
                    vo.setKuaidi_status(expresses.getStatus());
                } else {
                    vo.setExpress_number("");
                    vo.setExpress_company("");
                    vo.setKuaidi_status(-2);
                }
                vo.setOrderTicketEntitiesVo(kylinOrderTicketEntitiesVoList);
                vo.setPerformanceVo(performanceVo);
                vo.setOrderTicketVo(orderTicketVo);
            }
            return vo;
        } catch (Exception e) {
            return vo;
        }
    }
}
