package com.liquidnet.service.platform.controller.candy;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.candy.dto.CandyCommonCouponBasicDto;
import com.liquidnet.service.candy.dto.CandyUserCouponBasicDto;
import com.liquidnet.service.platform.service.impl.candy.PlatformCandyUserCouponService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDateTime;
import java.util.List;

@Api(tags = "券系统-数据降级查询")
@Slf4j
@RestController
@RequestMapping("cdemote")
public class PlatformCandyDemoteController {
    @Autowired
    private PlatformCandyUserCouponService platformCandyUserCouponService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "用户私有券")
    @PostMapping("ucoupon")
    public ResponseDto<List<CandyUserCouponBasicDto>> queryForUserCouponBasicDto() {
        return ResponseDto.success(platformCandyUserCouponService.ucouponBasicDtoByUidProcessing(CurrentUtil.getCurrentUid()));
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "用户公有券")
    @PostMapping("ccoupon")
    public ResponseDto<List<CandyCommonCouponBasicDto>> queryForCommonCouponBasicDto() {
        LocalDateTime ucreatedAt = (LocalDateTime) CurrentUtil.getTokenClaims().get(CurrentUtil.TOKEN_UCREATED);
        return ResponseDto.success(platformCandyUserCouponService.ccouponBasicDtoByUidProcessing(ucreatedAt));
    }

}
