package com.liquidnet.common.third.xuper.dto;

import lombok.Data;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: 查询指定资产碎片信息
 * @class: Xuper001GetStokenReqDto
 * @Package com.liquidnet.common.third.xuper.dto
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/4/18 15:10
 */
@Data
public class Xuper010QuerySdsRespDto {
    public long requestId;
    public int errNo;
    public String errMsg;
    public ShardMeta meta;

    @Data
    public static class ShardMeta {
        public long assetId;
        public long shardId;
        public String ownerAddr;
        public long uid;
        public long price;
        public int status;
        public String txId;
        public ShardAssetInfo assetInfo;
        public long ctime;
    }

    @Data
    public static class ShardAssetInfo {
        public String title;
        public int assetCate;
        public Thumb[] thumb;
        public String shortDesc;
        public String createAddr;
        public long groupId;
    }

    @Data
    public static class Thumb {
        private Urls urls;
        private String width;
        private String height;
    }

    @Data
    public static class Urls {
        private String icon;
        private String url1;
        private String url2;
        private String url3;
    }

    private static final Xuper010QuerySdsRespDto obj = new Xuper010QuerySdsRespDto();
    public static Xuper010QuerySdsRespDto getNew() {
        try {
            return (Xuper010QuerySdsRespDto) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new Xuper010QuerySdsRespDto();
        }
    }
}
