package com.liquidnet.service.goblin.service.manage;

import com.liquidnet.service.base.PagedResult;
import com.liquidnet.service.goblin.dto.manage.*;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsInfoVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsListVo;

public interface IGoblinstoreMgtGoodsService {
    /**
     * 商品管理:SPU列表
     *
     * @param storeMgtGoodsFilterParam GoblinStoreMgtGoodsFilterParam
     * @return PagedResult<GoblinStoreMgtGoodsVo>
     */
    PagedResult<GoblinStoreMgtGoodsListVo> goodsList(GoblinStoreMgtGoodsFilterParam storeMgtGoodsFilterParam);

    /**
     * 商品管理:SPU添加
     *
     * @param storeMgtGoodsAddParam GoblinStoreMgtGoodsAddParam
     */
    void goodsAdd(GoblinStoreMgtGoodsAddParam storeMgtGoodsAddParam);

    /**
     * 商品管理:SPU详情
     *
     * @param spuId 商品ID
     * @return GoblinStoreMgtGoodsInfoVo
     */
    GoblinStoreMgtGoodsInfoVo goodsInfo(String spuId);

    /**
     * 商品管理:商品编辑:SPU编辑
     *
     * @param storeMgtGoodsAddParam GoblinStoreMgtGoodsAddParam
     */
    void goodsEditSpu(GoblinStoreMgtGoodsAddParam storeMgtGoodsAddParam);

    /**
     * 商品管理:商品编辑:SKU编辑
     *
     * @param storeMgtGoodsEditSkuParam GoblinStoreMgtGoodsEditSkuParam
     */
    void goodsEditSku(GoblinStoreMgtGoodsEditSkuParam storeMgtGoodsEditSkuParam);

    /**
     * 商品管理:商品编辑:SKU添加
     *
     * @param storeMgtGoodsEditSkuParam GoblinStoreMgtGoodsEditSkuParam
     */
    void goodsEditSkuAdd(GoblinStoreMgtGoodsEditSkuParam storeMgtGoodsEditSkuParam);

    /**
     * 商品管理:商品编辑:SKU删除
     *
     * @param skuId 单品ID
     * @return boolean
     */
    boolean goodsEditSkuDel(String skuId);

    /**
     * 商品管理:商品编辑:SKU批改
     *
     * @param spuId       商品ID
     * @param batField    批量修改属性
     * @param batFieldVal 批量修改属性值
     * @return boolean
     */
    boolean goodsEditSkuBat(String spuId, String batField, String batFieldVal);

    /**
     * 商品管理:上架商品
     *
     * @param storeMgtGoodsActionParam GoblinStoreMgtGoodsActionParam
     */
    void goodsOnshelves(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam);

    /**
     * 商品管理:下架商品
     *
     * @param storeMgtGoodsActionParam GoblinStoreMgtGoodsActionParam
     */
    void goodsUnshelves(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam);

    /**
     * 商品管理:删除商品
     *
     * @param storeMgtGoodsActionParam GoblinStoreMgtGoodsActionParam
     */
    void goodsRemove(GoblinStoreMgtGoodsActionParam storeMgtGoodsActionParam);
}
