package com.liquidnet.client.admin.zhengzai.goblin.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.liquidnet.client.admin.zhengzai.goblin.service.IGoblinFrontSelectGoodsService;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.goblin.entity.GoblinFrontSelectGoods;
import com.liquidnet.service.goblin.mapper.GoblinFrontSelectGoodsMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 精选商品
 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-01-04
 */
@Service
public class GoblinFrontSelectGoodsServiceImpl extends ServiceImpl<GoblinFrontSelectGoodsMapper, GoblinFrontSelectGoods> implements IGoblinFrontSelectGoodsService {

    //private GoblinGoodsMapper goblinGoodsMapper;
    @Autowired
    private GoblinFrontSelectGoodsMapper goblinFrontSelectGoodsMapper;

    public boolean create(GoblinFrontSelectGoods goblinFrontSelectGoods){
        List list= this.getList();
        if(list.size()>0){
            return false;
        }
        //
        goblinFrontSelectGoods.setCreateTime(LocalDateTime.now());
        //设置bannerid
        goblinFrontSelectGoods.setSelectGoodsId(IDGenerator.nextSnowId());
        //增加 banner
        //goblinFrontSeckillMapper.insert(goblinFrontSeckill);
        goblinFrontSelectGoodsMapper.insert(goblinFrontSelectGoods);
        return true;
    }
    public GoblinFrontSelectGoods getOne(Long id){
        return  goblinFrontSelectGoodsMapper.selectById(id);
    }

    public boolean delte(Long id){
        GoblinFrontSelectGoods goblinFrontSelectGoods=goblinFrontSelectGoodsMapper.selectById(id);
        goblinFrontSelectGoods.setDelTag(1);
        this.update(goblinFrontSelectGoods);
        return true;
    }

    public boolean update(GoblinFrontSelectGoods goblinFrontSelectGoods){
        goblinFrontSelectGoods.setUpdateTime(LocalDateTime.now());
        goblinFrontSelectGoodsMapper.updateById(goblinFrontSelectGoods);
        return true;
    }

   public  List getList(){
       LambdaQueryWrapper<GoblinFrontSelectGoods> queryWrapper = Wrappers.lambdaQuery(GoblinFrontSelectGoods.class);
       queryWrapper.eq(GoblinFrontSelectGoods::getDelTag,0);
       return goblinFrontSelectGoodsMapper.selectList(queryWrapper);
   }
    public boolean online(){
      //查询
        LambdaQueryWrapper<GoblinFrontSelectGoods> queryWrapper = Wrappers.lambdaQuery(GoblinFrontSelectGoods.class);
        queryWrapper.eq(GoblinFrontSelectGoods::getDelTag,0);
        List<GoblinFrontSelectGoods> list=goblinFrontSelectGoodsMapper.selectList(queryWrapper);


        /*//mongodb
        for(GoblinFrontSeckill goblinFrontSeckill: list){
            GoblinFrontSeckill goblinFrontNavigation1=mongoTemplate.findOne(Query.query(Criteria.where("seckilId").is(goblinFrontSeckill.getSeckilId())), GoblinFrontSeckill.class, GoblinFrontSeckill.class.getSimpleName());
            if(null==goblinFrontNavigation1){
                mongoTemplate.save(goblinFrontSeckill,GoblinFrontSeckill.class.getSimpleName());
            }else{
                BasicDBObject orderObject = new BasicDBObject("$set", JSON.parse(JsonUtils.toJson(goblinFrontSeckill)));
                mongoTemplate.getCollection(GoblinFrontSeckill.class.getSimpleName()).updateOne(
                        Query.query(Criteria.where("seckilId").is(goblinFrontSeckill.getSeckilId())).getQueryObject(),
                        orderObject
                );
            }
        }
        //redis  保存秒杀表信息
        redisGoblinUtil.set(GoblinRedisConst.FRONT_SECKILL,list);*/
        return  true;
    }
}
