package com.liquidnet.service.goblin.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtCouponListVo;
import com.liquidnet.service.goblin.dto.manage.vo.GoblinStoreMgtGoodsListVo;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Getter
@Setter
@EqualsAndHashCode
public class GoblinStoreMgtCouponListVoExcel implements Serializable, Cloneable {
    private static final long serialVersionUID = 3264197773499339729L;
    @ExcelProperty("卡券编码")
    private String storeCouponNo;
    @ExcelProperty("卡券名称")
    private String title;
    @ExcelProperty("卡券状态")
    private String state;
    @ExcelProperty("开始时间")
    private String startTime;
    @ExcelProperty("结束时间")
    private String endTime;
    @ExcelProperty("创建时间")
    private String createdAt;
    @ExcelProperty("已领取库存")
    private Integer receiveStock;
    @ExcelProperty("已使用库存")
    private Integer usedStock;

    @ExcelProperty("总库存")
    private Integer stock;


    private static final GoblinStoreMgtCouponListVoExcel obj = new GoblinStoreMgtCouponListVoExcel();

    public static GoblinStoreMgtCouponListVoExcel getNew() {
        try {
            return (GoblinStoreMgtCouponListVoExcel) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinStoreMgtCouponListVoExcel();
        }
    }

    public GoblinStoreMgtCouponListVoExcel copy(GoblinStoreMgtCouponListVo source) {
        if (null == source) return this;
        this.setStoreCouponNo(source.getStoreCouponNo());
        this.setTitle(source.getTitle());
        switch (source.getState()) {
            case "0":
                this.setState("等待开始");break;
            case "1":
                this.setState("活动中");break;
            case "2":
                this.setState("活动结束");break;
            case "3":
                this.setState("已上架");break;
            default:
                this.setState("停用");break;
        }
        DateUtil.Formatter yyyyMMddHHmmss = DateUtil.Formatter.yyyyMMddHHmmss;
        this.setStartTime(yyyyMMddHHmmss.format(source.getStartTime()));
        this.setEndTime(yyyyMMddHHmmss.format(source.getEndTime()));
        this.setCreatedAt(yyyyMMddHHmmss.format(source.getCreatedAt()));
        this.setReceiveStock(source.getReceiveStock());
        this.setUsedStock(source.getUsedStock());
        this.setStock(source.getStock());
        return this;
    }
}
