package com.liquidnet.service.sweet.dto.vo.admin;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.liquidnet.commons.lang.util.DateUtil;
import com.liquidnet.service.sweet.entity.SweetIntegralActivityPrize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * <p>
 * SweetIntegralActivityVo
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-10-20
 */

@Data
@ApiModel
public class SweetIntegralActivityPrizeVo implements Serializable, Cloneable {

    private static final long serialVersionUID = 4229281062171296759L;

    @ApiModelProperty(value = "奖品id")
    private String prizeId;

    @ApiModelProperty(value = "关联活动id")
    private String integralActivityId;

    @ApiModelProperty(value = "奖品名称")
    private String prizeTitle;

    @ApiModelProperty(value = "奖品描述")
    private String prizeDescribe;

    @ApiModelProperty(required = true, value = "初始展示奖品图片")
    private String prizeImgInit;

    @ApiModelProperty(required = true, value = "中奖选中奖品图片")
    private String prizeImgSelect;

    @ApiModelProperty(value = "奖品类型 1积分 2优惠券 3实物 4登登登VIP")
    private Integer prizeType;

    @ApiModelProperty(value = "单次奖励数量如积分 中奖给多少物")
    private Integer prizeTypeNum;

    @ApiModelProperty(value = "奖品数量")
    private Integer prizeNum;

    @ApiModelProperty(value = "是否是无限库存 1有限库存 2无限")
    private Integer isInfinite;

    @ApiModelProperty(value = "中奖概率")
    private BigDecimal winningProbability;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime createdAt;

    @ApiModelProperty(value = "更新时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime updatedAt;

    @ApiModelProperty(value = "已发出数量")
    private Integer winPrizeNum;

    private static final SweetIntegralActivityPrizeVo obj = new SweetIntegralActivityPrizeVo();

    public static SweetIntegralActivityPrizeVo getNew() {
        try {
            return (SweetIntegralActivityPrizeVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new SweetIntegralActivityPrizeVo();
        }
    }

    public SweetIntegralActivityPrizeVo copy(SweetIntegralActivityPrize source) {
        if (null == source) return this;
        this.setPrizeId(source.getPrizeId());
        this.setIntegralActivityId(source.getIntegralActivityId());
        this.setPrizeTitle(source.getPrizeTitle());
        this.setPrizeDescribe(source.getPrizeDescribe());
        this.setPrizeImgInit(source.getPrizeImgInit());
        this.setPrizeImgSelect(source.getPrizeImgSelect());
        this.setPrizeType(source.getPrizeType());
        this.setPrizeTypeNum(source.getPrizeTypeNum());
        this.setPrizeNum(source.getPrizeNum());
        this.setWinningProbability(source.getWinningProbability());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        return this;
    }

}
