package com.liquidnet.service.sweet.controller;


import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.dto.param.poster.SweetStrawberryParam;
import com.liquidnet.service.sweet.service.ISweetStrawberryPosterService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 2021草莓音乐节海报活动表 前端控制器
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-11-25
 */
@Api(tags = "活动-2021草莓音乐节海报")
@RestController
@RequestMapping("/strawberryPoster")
public class SweetStrawberryPosterController {

    @Autowired
    private ISweetStrawberryPosterService posterService;

    @PostMapping("addUserLikeMusician")
    @ApiOperation("用户添加喜爱音乐人")

    public ResponseDto<Boolean> addUserLikeMusician(@RequestBody SweetStrawberryParam sweetStrawberryParam){
        return posterService.addUserLikeMusician(sweetStrawberryParam);
    }

}
