package com.liquidnet.service.adam.dto;

import com.liquidnet.commons.lang.constant.LnsRegex;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.*;

@ApiModel(value = "AdamEntersParam", description = "添加/编辑入场人入参")
@Data
public class AdamEntersParam implements java.io.Serializable {
    private static final long serialVersionUID = 8628253022063935727L;
    @ApiModelProperty(position = 10, required = false, value = "入场人ID，编辑时必传[50]")
    private String entersId;
    @ApiModelProperty(position = 11, required = true, value = "入场人姓名[50]", example = "测试")
    @Size(min = 1, max = 30, message = "姓名长度限制1-30位")
    private String name;
    @ApiModelProperty(position = 12, required = true, value = "入场人手机号[11]", example = "13100000000")
    @Pattern(regexp = "\\d{11}", message = "手机号格式有误")
    private String mobile;
    @ApiModelProperty(position = 13, required = true, value = "证件类型:1-大陆身份证,2-港澳通行证,3-台胞证,4-护照,5-军官证", allowableValues = "1,2,3,4,5")
    @NotNull(message = "证件类型不能位空") @Min(value = 1, message = "证件类型无效") @Max(value = 5, message = "证件类型无效")
    private Integer type;
    @ApiModelProperty(position = 14, required = true, value = "入场人证件号[30]", example = "110101110001010111")
    @Pattern(regexp = LnsRegex.Valid.LETTER_NUMBER, message = "证件号格式有误")
    @Size(min = 1, max = 30, message = "证件号长度限制1-30位")
    private String idCard;
}
