package com.liquidnet.client.admin.web.controller.zhengzai.smile;


import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.zhengzai.smile.dto.ShowSort;
import com.liquidnet.client.admin.zhengzai.smile.dto.ShowVo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileShowParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileShowService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author TT
 */
@Api(tags = "学校管理")
@RestController
@RequestMapping("/smile/show")
public class SmileShowController {

    @Autowired
    ISmileShowService smileShowService;

    @PostMapping("/list")
    @ApiOperation("演出列表")
    @ResponseBody
    public AjaxResult schoolList(SmileShowParam smileShowParam) {
        List<ShowVo> list = smileShowService.listShow(smileShowParam);
        return AjaxResult.success(list);
    }

    @GetMapping("/getShowById")
    @ApiOperation("根据演出id查询演出详情")
    public AjaxResult getShowById(String performancesId){
        return smileShowService.getShowById(performancesId);
    }

    @PostMapping("/sort")
    @ApiOperation("演出排序")
    public AjaxResult sort(ShowSort showSort){
        return smileShowService.sort(showSort);
    }

    @PostMapping("/make")
    @ApiOperation("打款")
    public AjaxResult make(String performancesId){
        return smileShowService.make(performancesId);
    }
}
