package com.liquidnet.client.admin.zhengzai.smile.service.impl;


import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageInfo;
import com.liquidnet.client.admin.common.core.domain.AjaxResult;
import com.liquidnet.client.admin.common.utils.StringUtils;
import com.liquidnet.client.admin.zhengzai.smile.dto.ShowSort;
import com.liquidnet.client.admin.zhengzai.smile.dto.ShowVo;
import com.liquidnet.client.admin.zhengzai.smile.dto.SmileShowParam;
import com.liquidnet.client.admin.zhengzai.smile.service.ISmileShowService;
import com.liquidnet.client.admin.zhengzai.smile.utils.SmileRedisUtils;
import com.liquidnet.service.goblin.constant.SmileRedisConst;
import com.liquidnet.service.kylin.entity.KylinOrderTickets;
import com.liquidnet.service.kylin.entity.KylinPerformances;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketRelationsMapper;
import com.liquidnet.service.kylin.mapper.KylinOrderTicketsMapper;
import com.liquidnet.service.kylin.mapper.KylinPerformancesMapper;
import com.liquidnet.service.kylin.mapper.KylinTicketStatusMapper;
import com.liquidnet.service.kylin.service.admin.IKylinPerformancesAdminService;
import com.liquidnet.service.smile.entity.SmileSchool;
import com.liquidnet.service.smile.mapper.SmileSchoolMapper;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2022-03-14
 */
@Slf4j
@Service
public class SmileShowServiceImpl extends ServiceImpl<SmileSchoolMapper, SmileSchool> implements ISmileShowService {

    @Autowired
    KylinTicketStatusMapper ticketStatusMapper;

    @Autowired
    SmileRedisUtils smileRedisUtils;

    @Autowired
    private KylinPerformancesMapper performancesMapper;

    @Autowired
    MongoTemplate mongoTemplate;

    @Autowired
    IKylinPerformancesAdminService kylinPerformancesService;

    @Autowired
    KylinPerformancesMapper kylinPerformancesMapper;

    @Autowired
    private KylinOrderTicketRelationsMapper kylinOrderTicketRelationsMapper;

    @Autowired
    KylinOrderTicketsMapper kylinOrderTicketsMapper;

    @Override
    public List<ShowVo> listShow(SmileShowParam smileShowParam) {
        PageInfo<KylinPerformances> pageInfo;
        //查询所有代理的演出id
        List<KylinPerformances> kylinPerformancesList = kylinPerformancesMapper.selectPerIdByAgent();

        return kylinPerformancesList.stream().map(kylinPerformances -> {
            ShowVo vo = new ShowVo();
            //演出id
            vo.setPerformancesId(kylinPerformances.getPerformancesId());
            //演出名称
            vo.setTitle(kylinPerformances.getTitle());
            //城市
            vo.setCityName(kylinPerformances.getCityName());
            //根据演出id  查询所有订单
            List<KylinOrderTickets> kylinOrderTicketsList = kylinOrderTicketsMapper.selectListByPerformanceId(kylinPerformances.getPerformancesId());

            Integer open = 0;
            BigDecimal totalAmount = BigDecimal.valueOf(0);
            for (KylinOrderTickets kylinOrderTickets : kylinOrderTicketsList) {
                //演出张数
                open += (kylinOrderTickets.getNumber() - kylinOrderTickets.getRefundNumber());
                //总销售金额
                totalAmount = totalAmount.add(kylinOrderTickets.getPriceActual()).subtract(kylinOrderTickets.getPriceRefund());
            }
            //根据演出id查询销售代理
            vo.setTotalOutAgent(kylinOrderTicketRelationsMapper.concatByAgentDed(kylinPerformances.getPerformancesId()));
            //演出结束时间
            vo.setTimeEnd(kylinPerformances.getTimeEnd());

            return vo;
        }).collect(Collectors.toList());
    }

    @Override
    public AjaxResult sort(ShowSort showSort) {
        //查询数据库是否又该顺序的演出
        kylinPerformancesMapper.updateComment(showSort.getSort());
        kylinPerformancesMapper.updateCommentByPer(showSort.getSort(), showSort.getPerformancesId());

        //获取排序演出id
        List<String> collect = kylinPerformancesMapper.selectByComment().stream().map(KylinPerformances::getPerformancesId).collect(Collectors.toList());
        String perId = StringUtils.strip(collect.toString(), "[]");
        smileRedisUtils.set(SmileRedisConst.SMILE_SHOW, perId);
        return AjaxResult.success();
    }

    @Override
    public AjaxResult make(String performancesId) {
        if (!smileRedisUtils.hasKey(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId))) {
            smileRedisUtils.set(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId), 1);
        } else {
            smileRedisUtils.del(SmileRedisConst.SELL_SHOW_PAYMENT.concat(performancesId));
        }
        return AjaxResult.success();
    }

    @Override
    public AjaxResult getShowById(String performancesId) {

        return null;
    }


}
