package com.liquidnet.service.sweet.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.IDGenerator;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.sweet.entity.SweetStage;
import com.liquidnet.service.sweet.mapper.SweetStageMapper;
import com.liquidnet.service.sweet.service.ISweetStageService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 舞台表 服务实现类
 * </p>
 *
 * @author liquidnet
 * @since 2021-07-23
 */
@Service
public class SweetStageServiceImpl extends ServiceImpl<SweetStageMapper, SweetStage> implements ISweetStageService {

    @Autowired
    private SweetStageMapper sweetStageMapper;

    @Override
    public ResponseDto<PageInfo<SweetStage>> getList(int page, int size,String title) {
        PageInfo<SweetStage> pageInfo = null;
        try {
            PageHelper.startPage(page, size);
            List<SweetStage> data = sweetStageMapper.selectList(Wrappers.lambdaQuery(SweetStage.class).like(SweetStage::getTitle,title));
            pageInfo = new PageInfo(data);
            return ResponseDto.success(pageInfo);
        } catch (Exception e) {
            return ResponseDto.success(pageInfo);
        }
    }

    @Override
    public ResponseDto<Boolean> add(String name) {
        try {
            SweetStage sweetStage = new SweetStage();
            sweetStage.setStageId(IDGenerator.nextSnowId());
            sweetStage.setTitle(name);
            sweetStage.setCreatedAt(LocalDateTime.now());
            sweetStageMapper.insert(sweetStage);
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<SweetStage> detail(String stageId) {
        try {
            return ResponseDto.success(sweetStageMapper.selectOne(Wrappers.lambdaQuery(SweetStage.class).eq(SweetStage::getStageId, stageId)));
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }

    @Override
    public ResponseDto<Boolean> change(String name, String stageId) {
        try {
            SweetStage sweetStage = new SweetStage();
            sweetStage.setTitle(name);
            sweetStage.setUpdatedAt(LocalDateTime.now());
            sweetStageMapper.update(sweetStage, Wrappers.lambdaUpdate(SweetStage.class).eq(SweetStage::getStageId, stageId));
            return ResponseDto.success();
        } catch (Exception e) {
            return ResponseDto.failure();
        }
    }
}
