package com.liquidnet.common.third.zxlnft.util;

import com.liquidnet.common.third.zxlnft.biz.ZxlnftBiz;
import com.liquidnet.common.third.zxlnft.config.ZxlnftConfig;
import com.liquidnet.common.third.zxlnft.dto.*;
import com.liquidnet.common.third.zxlnft.dto.nft.*;
import com.liquidnet.common.third.zxlnft.exception.ZxlNftException;
import com.liquidnet.common.third.zxlnft.service.ZxlnftSdkService;
import com.liquidnet.commons.lang.util.BeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author AnJiabin <anjiabin@zhengzai.tv>
 * @version V1.0
 * @Description: TODO
 * @class: ZxlnftSdkUtil
 * @Package com.liquidnet.common.third.zxlnft.util
 * @Copyright: LightNet @ Copyright (c) 2022
 * @date 2022/2/24 16:08
 */
@Slf4j
@Component
public class ZxlnftSdkUtil {
    @Autowired
    private ZxlnftConfig zxlnftConfig;

    @Autowired
    private ZxlnftSdkService zxlnftSdkService;

    @Autowired
    private ZxlnftBiz zxlnftBiz;

    public ZxlnftResponseDto<Nft001RegisterVerifyCodeRespDto> nft001RegisterVerifyCode(Nft001RegisterVerifyCodeReqDto reqDto){
        /**
         * 构造请求
         */
        Nft001RegisterVerifyCodeReq req = Nft001RegisterVerifyCodeReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft001RegisterVerifyCodeRespDto respDto = Nft001RegisterVerifyCodeRespDto.getNew();
        try{
            Nft001RegisterVerifyCodeResp resp = zxlnftSdkService.nft001RegisterVerifyCode(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft002RegisterPersonRespDto> nft002RegisterPerson(Nft002RegisterPersonReqDto reqDto){
        /**
         * 构造请求
         */
        Nft002RegisterPersonReq req = Nft002RegisterPersonReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft002RegisterPersonRespDto respDto = Nft002RegisterPersonRespDto.getNew();
        try{
            Nft002RegisterPersonResp resp = zxlnftSdkService.nft002RegisterPerson(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft003RegisterPersonPlatformRespDto> nft003RegisterPersonPlatform(Nft003RegisterPersonPlatformReqDto reqDto){
        /**
         * 构造请求
         */
        Nft003RegisterPersonPlatformReq req = Nft003RegisterPersonPlatformReq.getNew();
        BeanUtil.copy(reqDto,req);
        req.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());
        /**
         * 平台签名信息：sign(personName_mobile_idCard)
         */
        String signMetaData = req.getPersonName()
                .concat("_").concat(req.getMobile())
                .concat("_").concat(req.getIdCard());
        String signature = zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),signMetaData);
        req.setPlatformSignData(signature);

        Nft003RegisterPersonPlatformRespDto respDto = Nft003RegisterPersonPlatformRespDto.getNew();
        try{
            Nft003RegisterPersonPlatformResp resp = zxlnftSdkService.nft003RegisterPersonPlatform(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft004BusinessLicenseUploadRespDto> nft004BusinessLicenseUpload(Nft004BusinessLicenseUploadReqDto reqDto){
        /**
         * 构造请求
         */
        Nft004BusinessLicenseUploadReq req = Nft004BusinessLicenseUploadReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft004BusinessLicenseUploadRespDto respDto = Nft004BusinessLicenseUploadRespDto.getNew();
        try{
            Nft004BusinessLicenseUploadResp resp = zxlnftSdkService.nft004BusinessLicenseUpload(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft005BusinessLicenseUploadPlatformRespDto> nft005BusinessLicenseUploadPlatform(Nft005BusinessLicenseUploadPlatformReqDto reqDto){
        /**
         * 构造请求
         */
        Nft005BusinessLicenseUploadPlatformReq req = Nft005BusinessLicenseUploadPlatformReq.getNew();
        BeanUtil.copy(reqDto,req);

        req.setPlatformIdentification(zxlnftConfig.getPlatformIdentification());
        req.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());
        /**
         * 平台签名信息：sign(platformIdentification)
         */
        String signMetaData = req.getPlatformIdentification();
        String signature = zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),signMetaData);
        req.setPlatformSignData(signature);

        Nft005BusinessLicenseUploadPlatformRespDto respDto = Nft005BusinessLicenseUploadPlatformRespDto.getNew();
        try{
            Nft005BusinessLicenseUploadPlatformResp resp = zxlnftSdkService.nft005BusinessLicenseUploadPlatform(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft006OfficialLetterUploadRespDto> nft006OfficialLetterUpload(Nft006OfficialLetterUploadReqDto reqDto){
        /**
         * 构造请求
         */
        Nft006OfficialLetterUploadReq req = Nft006OfficialLetterUploadReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft006OfficialLetterUploadRespDto respDto = Nft006OfficialLetterUploadRespDto.getNew();
        try{
            Nft006OfficialLetterUploadResp resp = zxlnftSdkService.nft006OfficialLetterUpload(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft007OfficialLetterUploadPlatformRespDto> nft007OfficialLetterUploadPlatform(Nft007OfficialLetterUploadPlatformReqDto reqDto){
        /**
         * 构造请求
         */
        Nft007OfficialLetterUploadPlatformReq req = Nft007OfficialLetterUploadPlatformReq.getNew();
        BeanUtil.copy(reqDto,req);

        req.setPlatformIdentification(zxlnftConfig.getPlatformIdentification());
        req.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());
        /**
         * 平台签名信息：sign(platformIdentification)
         */
        String signMetaData = req.getPlatformIdentification();
        String signature = zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),signMetaData);
        req.setPlatformSignData(signature);

        Nft007OfficialLetterUploadPlatformRespDto respDto = Nft007OfficialLetterUploadPlatformRespDto.getNew();
        try{
            Nft007OfficialLetterUploadPlatformResp resp = zxlnftSdkService.nft007OfficialLetterUploadPlatform(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft008QueryImageModerationRespDto> nft008QueryImageModeration(Nft008QueryImageModerationReqDto reqDto){
        /**
         * 构造请求
         */
        Nft008QueryImageModerationReq req = Nft008QueryImageModerationReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft008QueryImageModerationRespDto respDto = Nft008QueryImageModerationRespDto.getNew();
        try{
            Nft008QueryImageModerationResp resp = zxlnftSdkService.nft008QueryImageModeration(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft009RegisterCompanyRespDto> nft009RegisterCompany(Nft009RegisterCompanyReqDto reqDto){
        /**
         * 构造请求
         */
        Nft009RegisterCompanyReq req = Nft009RegisterCompanyReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft009RegisterCompanyRespDto respDto = Nft009RegisterCompanyRespDto.getNew();
        try{
            Nft009RegisterCompanyResp resp = zxlnftSdkService.nft009RegisterCompany(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft010RegisterCompanyPlatformRespDto> nft010RegisterCompanyPlatform(Nft010RegisterCompanyPlatformReqDto reqDto){
        /**
         * 构造请求
         */
        Nft010RegisterCompanyPlatformReq req = Nft010RegisterCompanyPlatformReq.getNew();
        BeanUtil.copy(reqDto,req);

        req.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());
        /**
         * 平台签名信息:sign(epName_creditCode_representativeName_contact_mobile_idcard)
         */
        String signMetaData = req.getEpName()
                .concat("_").concat(req.getCreditCode())
                .concat("_").concat(req.getRepresentativeName())
                .concat("_").concat(req.getContact())
                .concat("_").concat(req.getMobile())
                .concat("_").concat(req.getIdcard());
        String signature = zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),signMetaData);
        req.setPlatformSignData(signature);

        Nft010RegisterCompanyPlatformRespDto respDto = Nft010RegisterCompanyPlatformRespDto.getNew();
        try{
            Nft010RegisterCompanyPlatformResp resp = zxlnftSdkService.nft010RegisterCompanyPlatform(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft011UserQueryVerifyCodeRespDto> nft011UserQueryVerifyCode(Nft011UserQueryVerifyCodeReqDto reqDto){
        /**
         * 构造请求
         */
        Nft011UserQueryVerifyCodeReq req = Nft011UserQueryVerifyCodeReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft011UserQueryVerifyCodeRespDto respDto = Nft011UserQueryVerifyCodeRespDto.getNew();
        try{
            Nft011UserQueryVerifyCodeResp resp = zxlnftSdkService.nft011UserQueryVerifyCode(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft012UserQueryRespDto> nft012UserQuery(Nft012UserQueryReqDto reqDto){
        /**
         * 构造请求
         */
        Nft012UserQueryReq req = Nft012UserQueryReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft012UserQueryRespDto respDto = Nft012UserQueryRespDto.getNew();
        try{
            Nft012UserQueryResp resp = zxlnftSdkService.nft012UserQuery(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft013IdentityBindSubmitRespDto> nft013IdentityBindSubmit(Nft013IdentityBindSubmitReqDto reqDto){
        /**
         * 构造请求
         */
        Nft013IdentityBindSubmitReq req = Nft013IdentityBindSubmitReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft013IdentityBindSubmitRespDto respDto = Nft013IdentityBindSubmitRespDto.getNew();
        try{
            Nft013IdentityBindSubmitResp resp = zxlnftSdkService.nft013IdentityBindSubmit(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft014IdentityBindSubmitByTrustedRespDto> nft014IdentityBindSubmitByTrusted(Nft014IdentityBindSubmitByTrustedReqDto reqDto){
        /**
         * 构造请求
         */
        Nft014IdentityBindSubmitByTrustedReq req = Nft014IdentityBindSubmitByTrustedReq.getNew();
        BeanUtil.copy(reqDto,req);

        req.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());
        /**
         * 平台签名信息:sign(epName_creditCode_representativeName_contact_mobile_idcard)
         */
        String signMetaData = req.getUserSignData();
        String signature = zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),signMetaData);
        req.setPlatformSignData(signature);

        Nft014IdentityBindSubmitByTrustedRespDto respDto = Nft014IdentityBindSubmitByTrustedRespDto.getNew();
        try{
            Nft014IdentityBindSubmitByTrustedResp resp = zxlnftSdkService.nft014IdentityBindSubmitByTrusted(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft015IdentityBindPlatformSelfRespDto> nft015IdentityBindPlatformSelf(Nft015IdentityBindPlatformSelfReqDto reqDto){
        /**
         * 构造请求
         */
        Nft015IdentityBindPlatformSelfReq req = Nft015IdentityBindPlatformSelfReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft015IdentityBindPlatformSelfRespDto respDto = Nft015IdentityBindPlatformSelfRespDto.getNew();
        try{
            Nft015IdentityBindPlatformSelfResp resp = zxlnftSdkService.nft015IdentityBindPlatformSelf(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft016IdentityBindQueryRespDto> nft016IdentityBindQuery(Nft016IdentityBindQueryReqDto reqDto){
        /**
         * 构造请求
         */
        Nft016IdentityBindQueryReq req = Nft016IdentityBindQueryReq.getNew();
        BeanUtil.copy(reqDto,req);

        req.setAddressList(zxlnftConfig.getNftPlatformAddress());

        Nft016IdentityBindQueryRespDto respDto = Nft016IdentityBindQueryRespDto.getNew();
        try{
            Nft016IdentityBindQueryResp resp = zxlnftSdkService.nft016IdentityBindQuery(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft017IdentityVerifyIdentityRespDto> nft017IdentityVerifyIdentity(Nft017IdentityVerifyIdentityReqDto reqDto){
        /**
         * 构造请求
         */
        Nft017IdentityVerifyIdentityReq req = Nft017IdentityVerifyIdentityReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft017IdentityVerifyIdentityRespDto respDto = Nft017IdentityVerifyIdentityRespDto.getNew();
        try{
            Nft017IdentityVerifyIdentityResp resp = zxlnftSdkService.nft017IdentityVerifyIdentity(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft018FaceUrlRespDto> nft018FaceUrl(Nft018FaceUrlReqDto reqDto){
        /**
         * 构造请求
         */
        Nft018FaceUrlReq req = Nft018FaceUrlReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft018FaceUrlRespDto respDto = Nft018FaceUrlRespDto.getNew();
        try{
            Nft018FaceUrlResp resp = zxlnftSdkService.nft018FaceUrl(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft019FaceUrlByAddressRespDto> nft019FaceUrlByAddress(Nft019FaceUrlByAddressReqDto reqDto){
        /**
         * 构造请求
         */
        Nft019FaceUrlByAddressReq req = Nft019FaceUrlByAddressReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft019FaceUrlByAddressRespDto respDto = Nft019FaceUrlByAddressRespDto.getNew();
        try{
            Nft019FaceUrlByAddressResp resp = zxlnftSdkService.nft019FaceUrlByAddress(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft020FaceQueryRespDto> nft020FaceQuery(Nft020FaceQueryReqDto reqDto){
        /**
         * 构造请求
         */
        Nft020FaceQueryReq req = Nft020FaceQueryReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft020FaceQueryRespDto respDto = Nft020FaceQueryRespDto.getNew();
        try{
            Nft020FaceQueryResp resp = zxlnftSdkService.nft020FaceQuery(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft021UploadUrlRespDto> nft021UploadUrl(Nft021UploadUrlReqDto reqDto){
        /**
         * 构造请求
         */
        Nft021UploadUrlReq req = Nft021UploadUrlReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft021UploadUrlRespDto respDto = Nft021UploadUrlRespDto.getNew();
        try{
            Nft021UploadUrlResp resp = zxlnftSdkService.nft021UploadUrl(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft022UploadSecretRespDto>  nft022UploadSecret(Nft022UploadSecretReqDto reqDto){
        /**
         * 构造请求
         */
        Nft022UploadSecretReq req = Nft022UploadSecretReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft022UploadSecretRespDto respDto = Nft022UploadSecretRespDto.getNew();
        try{
            Nft022UploadSecretResp resp = zxlnftSdkService.nft022UploadSecret(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft023PointApplyRespDto> nft023PointApply(Nft023PointApplyReqDto reqDto){
        /**
         * 构造请求
         */
        Nft023PointApplyReq req = Nft023PointApplyReq.getNew();
        BeanUtil.copy(reqDto,req);

        req.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());
        /**
         * 平台方的私钥签名，签名对象和signature对象一致，签名对象是(platformPubKey_applyerAddr_接口名_count_operateId)  接口名=apply_point
         */
        String signMetaData = req.getPlatformPubKey()
                .concat("_").concat(req.getApplyerAddr())
                .concat("_").concat("apply_point")
                .concat("_").concat(req.getCount().toString())
                .concat("_").concat(req.getOperateId());
        String signature = zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),signMetaData);
        req.setPlatformSignature(signature);

        Nft023PointApplyRespDto respDto = Nft023PointApplyRespDto.getNew();
        try{
            Nft023PointApplyResp resp = zxlnftSdkService.nft023PointApply(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft024PointApplyResultRespDto> nft024PointApplyResult(Nft024PointApplyResultReqDto reqDto){
        /**
         * 构造请求
         */
        Nft024PointApplyResultReq req = Nft024PointApplyResultReq.getNew();
        BeanUtil.copy(reqDto,req);

        //设置平台公钥
        req.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());

        Nft024PointApplyResultRespDto respDto = Nft024PointApplyResultRespDto.getNew();
        try{
            Nft024PointApplyResultResp resp = zxlnftSdkService.nft024PointApplyResult(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft025PointTransferRespDto> nft025PointTransfer(Nft003RegisterPersonPlatformReqDto reqDto){
        /**
         * 构造请求
         */
        Nft025PointTransferReq req = Nft025PointTransferReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft025PointTransferRespDto respDto = Nft025PointTransferRespDto.getNew();
        try{
            Nft025PointTransferResp resp = zxlnftSdkService.nft025PointTransfer(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft026PointTransferResultRespDto> nft026PointTransferResult(Nft026PointTransferResultReqDto reqDto){
        /**
         * 构造请求
         */
        Nft026PointTransferResultReq req = Nft026PointTransferResultReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft026PointTransferResultRespDto respDto = Nft026PointTransferResultRespDto.getNew();
        try{
            Nft026PointTransferResultResp resp = zxlnftSdkService.nft026PointTransferResult(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft027PointDestroyRespDto> nft027PointDestroy(Nft027PointDestroyReqDto reqDto){
        /**
         * 构造请求
         */
        Nft027PointDestroyReq req = Nft027PointDestroyReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft027PointDestroyRespDto respDto = Nft027PointDestroyRespDto.getNew();
        try{
            Nft027PointDestroyResp resp = zxlnftSdkService.nft027PointDestroy(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft028PointDestoryResultRespDto> nft028PointDestoryResult(Nft028PointDestoryResultReqDto reqDto){
        /**
         * 构造请求
         */
        Nft028PointDestoryResultReq req = Nft028PointDestoryResultReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft028PointDestoryResultRespDto respDto = Nft028PointDestoryResultRespDto.getNew();
        try{
            Nft028PointDestoryResultResp resp = zxlnftSdkService.nft028PointDestoryResult(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft029PointQueryRespDto> nft029PointQuery(Nft029PointQueryReqDto reqDto){
        /**
         * 构造请求
         */
        Nft029PointQueryReq req = Nft029PointQueryReq.getNew();
        BeanUtil.copy(reqDto,req);

        //平台地址
        req.setPlatformAddr(zxlnftConfig.getNftPlatformAddress());

        Nft029PointQueryRespDto respDto = Nft029PointQueryRespDto.getNew();
        try{
            Nft029PointQueryResp resp = zxlnftSdkService.nft029PointQuery(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft030SeriesClaimRespDto> nft030SeriesClaim(Nft030SeriesClaimReqDto reqDto){
        /**
         * 构造请求
         */
        Nft030SeriesClaimReq req = Nft030SeriesClaimReq.getNew();
        BeanUtil.copy(reqDto,req);

        req.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());

        /**
         * 系列声明人的私钥签名，签名对象是（platformPubKey_pubKey_接口名_seriesName_totalCount_coverUrl_desc_maxPublishCount
         * _seriesBeginFromZero_operateId） 接口名：series_claim
         */
        String signMetaData = req.getPlatformPubKey()
                .concat("_").concat(req.getPubKey())
                .concat("_").concat("series_claim")
                .concat("_").concat(req.getSeriesName())
                .concat("_").concat(req.getTotalCount().toString())
                .concat("_").concat(req.getCoverUrl())
                .concat("_").concat(req.getDesc())
                .concat("_").concat(req.getMaxPublishCount().toString())
                .concat("_").concat(req.getSeriesBeginFromZero().toString())
                .concat("_").concat(req.getOperateId());
        String signature = zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),signMetaData);
        req.setSignature(signature);

        /**
         * 平台方的私钥签名，签名对象是（platformPubKey_pubKey_接口名_seriesName_totalCount_coverUrl_desc_maxPublishCount
         * _seriesBeginFromZero_operateId） 接口名：series_claim
         */
        String platformSignMetaData = req.getPlatformPubKey()
                .concat("_").concat(req.getPubKey())
                .concat("_").concat("series_claim")
                .concat("_").concat(req.getSeriesName())
                .concat("_").concat(req.getTotalCount().toString())
                .concat("_").concat(req.getCoverUrl())
                .concat("_").concat(req.getDesc())
                .concat("_").concat(req.getMaxPublishCount().toString())
                .concat("_").concat(req.getSeriesBeginFromZero().toString())
                .concat("_").concat(req.getOperateId());
        String platformSignature = zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),platformSignMetaData);
        req.setPlatformSignature(platformSignature);



        Nft030SeriesClaimRespDto respDto = Nft030SeriesClaimRespDto.getNew();
        try{
            Nft030SeriesClaimResp resp = zxlnftSdkService.nft030SeriesClaim(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft031SeriesClaimResultRespDto> nft031SeriesClaimResult(Nft031SeriesClaimResultReqDto reqDto){
        /**
         * 构造请求
         */
        Nft031SeriesClaimResultReq req = Nft031SeriesClaimResultReq.getNew();
        BeanUtil.copy(reqDto,req);

        req.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());

        Nft031SeriesClaimResultRespDto respDto = Nft031SeriesClaimResultRespDto.getNew();
        try{
            Nft031SeriesClaimResultResp resp = zxlnftSdkService.nft031SeriesClaimResult(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft032SeriesRespDto> nft032Series(Nft032SeriesReqDto reqDto){
        /**
         * 构造请求
         */
        Nft032SeriesReq req = Nft032SeriesReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft032SeriesRespDto respDto = Nft032SeriesRespDto.getNew();
        try{
            Nft032SeriesResp resp = zxlnftSdkService.nft032Series(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft033SeriesListRespDto> nft033SeriesList(Nft033SeriesListReqDto reqDto){
        /**
         * 构造请求
         */
        Nft033SeriesListReq req = Nft033SeriesListReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft033SeriesListRespDto respDto = Nft033SeriesListRespDto.getNew();
        try{
            Nft033SeriesListResp resp = zxlnftSdkService.nft033SeriesList(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft034PublishRespDto> nft034Publish(Nft034PublishReqDto reqDto){
        Nft034PublishReq req = Nft034PublishReq.getNew();
        BeanUtil.copy(reqDto,req);
        req.setPubKey(zxlnftConfig.getNftPlatformPubKey());
        req.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());
        req.setHash(zxlnftBiz.getHashString(req.getUrl()));

        /**
         * 发行人的私钥签名，签名对象是(platformPubKey_pubKey_接口名_author_name_url_displayUrl_hash_desc_flag_publishCount_seriesId_seriesBeginIndex
         * _sellStatus_sellCount_metaData_operateId)
         * 接口名：publish_nft
         */
        String signMetaData = req.getPlatformPubKey()
                .concat("_").concat(req.getPubKey())
                .concat("_").concat("publish_nft")
                .concat("_").concat(req.getAuthor())
                .concat("_").concat(req.getName())
                .concat("_").concat(req.getUrl())
                .concat("_").concat(req.getDisplayUrl())
                .concat("_").concat(req.getHash())
                .concat("_").concat(req.getDesc())
                .concat("_").concat(req.getFlag()==null?"":req.getFlag())
                .concat("_").concat(req.getPublishCount().toString())
                .concat("_").concat(req.getSeriesId()==null?"":req.getSeriesId())
                .concat("_").concat(req.getSeriesBeginIndex().toString())
                .concat("_").concat(req.getSellStatus().toString())
                .concat("_").concat(req.getSellCount()==null?Long.toString(0): req.getSellCount().toString())
                .concat("_").concat(req.getMetaData()==null?"":req.getMetaData())
                .concat("_").concat(req.getOperateId());
        String signature = zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),signMetaData);
        req.setSignature(signature);

        String platformSignature = zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),signMetaData);
        req.setPlatformSignature(platformSignature);

        Nft034PublishRespDto respDto = Nft034PublishRespDto.getNew();
        try{
            Nft034PublishResp resp = zxlnftSdkService.nft034Publish(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft035PublishResultRespDto> nft035PublishResult(Nft035PublishResultReqDto reqDto){
        /**
         * 构造请求
         */
        Nft035PublishResultReq req = Nft035PublishResultReq.getNew();
        BeanUtil.copy(reqDto,req);
        //设置平台公钥
        req.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());

        Nft035PublishResultRespDto respDto = Nft035PublishResultRespDto.getNew();
        try{
            Nft035PublishResultResp resp = zxlnftSdkService.nft035PublishResult(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft036InfoRespDto> nft036Info(Nft036InfoReqDto reqDto){
        /**
         * 构造请求
         */
        Nft036InfoReq req = Nft036InfoReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft036InfoRespDto respDto = Nft036InfoRespDto.getNew();
        try{
            Nft036InfoResp resp = zxlnftSdkService.nft036Info(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft037AddressListRespDto> nft037AddressList(Nft037AddressListReqDto reqDto){
        /**
         * 构造请求
         */
        Nft037AddressListReq req = Nft037AddressListReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft037AddressListRespDto respDto = Nft037AddressListRespDto.getNew();
        try{
            Nft037AddressListResp resp = zxlnftSdkService.nft037AddressList(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft038AddressWithoutSeriesListRespDto> nft038AddressWithoutSeriesList(Nft038AddressWithoutSeriesListReqDto reqDto){
        /**
         * 构造请求
         */
        Nft038AddressWithoutSeriesListReq req = Nft038AddressWithoutSeriesListReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft038AddressWithoutSeriesListRespDto respDto = Nft038AddressWithoutSeriesListRespDto.getNew();
        try{
            Nft038AddressWithoutSeriesListResp resp = zxlnftSdkService.nft038AddressWithoutSeriesList(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft039TradeListRespDto> nft039TradeList(Nft039TradeListReqDto reqDto){
        /**
         * 构造请求
         */
        Nft039TradeListReq req = Nft039TradeListReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft039TradeListRespDto respDto = Nft039TradeListRespDto.getNew();
        try{
            Nft039TradeListResp resp = zxlnftSdkService.nft039TradeList(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft040TradeInListRespDto> nft040TradeInList(Nft040TradeInListReqDto reqDto){
        /**
         * 构造请求
         */
        Nft040TradeInListReq req = Nft040TradeInListReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft040TradeInListRespDto respDto = Nft040TradeInListRespDto.getNew();
        try{
            Nft040TradeInListResp resp = zxlnftSdkService.nft040TradeInList(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft041TradeOutListRespDto> nft041TradeOutList(Nft041TradeOutListReqDto reqDto){
        /**
         * 构造请求
         */
        Nft041TradeOutListReq req = Nft041TradeOutListReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft041TradeOutListRespDto respDto = Nft041TradeOutListRespDto.getNew();
        try{
            Nft041TradeOutListResp resp = zxlnftSdkService.nft041TradeOutList(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft042TradeAllListRespDto> nft042TradeAllList(Nft041TradeOutListReqDto reqDto){
        /**
         * 构造请求
         */
        Nft042TradeAllListReq req = Nft042TradeAllListReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft042TradeAllListRespDto respDto = Nft042TradeAllListRespDto.getNew();
        try{
            Nft042TradeAllListResp resp = zxlnftSdkService.nft042TradeAllList(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft043BuyRespDto> nft043Buy(Nft043BuyReqDto reqDto){
        /**
         * 构造请求
         */
        Nft043BuyReq req = Nft043BuyReq.getNew();
        BeanUtil.copy(reqDto,req);

        //设置平台公钥
        req.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());
        /**
         * 接收人的私钥签名，签名对象是(platformPubKey_receiverPubKey_pointReceiverAddr_applyScore_接口名_nftId_offerCount_operateId)
         * 接口名：buy_nft
         */
        String signMetaData = req.getPlatformPubKey()
                .concat("_").concat(req.getReceiverPubKey())
                .concat("_").concat(req.getPointReceiverAddr())
                .concat("_").concat(req.getApplyScore().toString())
                .concat("_").concat("buy_nft")
                .concat("_").concat(req.getNftId())
                .concat("_").concat(req.getOfferCount().toString())
                .concat("_").concat(req.getOperateId());
        String signature = zxlnftBiz.createSign(zxlnftConfig.getNftPlatformPriKey(),signMetaData);
        req.setPlatformSignature(signature);


        Nft043BuyRespDto respDto = Nft043BuyRespDto.getNew();
        try{
            Nft043BuyResp resp = zxlnftSdkService.nft043Buy(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft044BuyResultRespDto> nft044BuyResult(Nft044BuyResultReqDto reqDto){
        /**
         * 构造请求
         */
        Nft044BuyResultReq req = Nft044BuyResultReq.getNew();
        BeanUtil.copy(reqDto,req);

        //设置平台公钥
        req.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());

        Nft044BuyResultRespDto respDto = Nft044BuyResultRespDto.getNew();
        try{
            Nft044BuyResultResp resp = zxlnftSdkService.nft044BuyResult(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft045BuyPayResultRespDto> nft045BuyPayResult(Nft045BuyPayResultReqDto reqDto){
        /**
         * 构造请求
         */
        Nft045BuyPayResultReq req = Nft045BuyPayResultReq.getNew();
        BeanUtil.copy(reqDto,req);

        //设置平台公钥
        req.setPlatformPubKey(zxlnftConfig.getNftPlatformPubKey());

        Nft045BuyPayResultRespDto respDto = Nft045BuyPayResultRespDto.getNew();
        try{
            Nft045BuyPayResultResp resp = zxlnftSdkService.nft045BuyPayResult(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft046TransferRespDto> nft046Transfer(Nft046TransferReqDto reqDto){
        /**
         * 构造请求
         */
        Nft046TransferReq req = Nft046TransferReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft046TransferRespDto respDto = Nft046TransferRespDto.getNew();
        try{
            Nft046TransferResp resp = zxlnftSdkService.nft046Transfer(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft047SelfTransferRespDto> nft047SelfTransfer(Nft047SelfTransferReqDto reqDto){
        /**
         * 构造请求
         */
        Nft047SelfTransferReq req = Nft047SelfTransferReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft047SelfTransferRespDto respDto = Nft047SelfTransferRespDto.getNew();
        try{
            Nft047SelfTransferResp resp = zxlnftSdkService.nft047SelfTransfer(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft048BatchTransferRespDto> nft048BatchTransfer(Nft048BatchTransferReqDto reqDto){
        /**
         * 构造请求
         */
        Nft048BatchTransferReq req = Nft048BatchTransferReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft048BatchTransferRespDto respDto = Nft048BatchTransferRespDto.getNew();
        try{
            Nft048BatchTransferResp resp = zxlnftSdkService.nft048BatchTransfer(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft049TransferResultRespDto> nft049TransferResult(Nft049TransferResultReqDto reqDto){
        /**
         * 构造请求
         */
        Nft049TransferResultReq req = Nft049TransferResultReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft049TransferResultRespDto respDto = Nft049TransferResultRespDto.getNew();
        try{
            Nft049TransferResultResp resp = zxlnftSdkService.nft049TransferResult(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft050StatusUpdateRespDto> nft050StatusUpdate(Nft050StatusUpdateReqDto reqDto){
        /**
         * 构造请求
         */
        Nft050StatusUpdateReq req = Nft050StatusUpdateReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft050StatusUpdateRespDto respDto = Nft050StatusUpdateRespDto.getNew();
        try{
            Nft050StatusUpdateResp resp = zxlnftSdkService.nft050StatusUpdate(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft051StatusUpdateResultRespDto> nft051StatusUpdateResult(Nft051StatusUpdateResultReqDto reqDto){
        /**
         * 构造请求
         */
        Nft051StatusUpdateResultReq req = Nft051StatusUpdateResultReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft051StatusUpdateResultRespDto respDto = Nft051StatusUpdateResultRespDto.getNew();
        try{
            Nft051StatusUpdateResultResp resp = zxlnftSdkService.nft051StatusUpdateResult(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft052PriceUpdateRespDto> nft052PriceUpdate(Nft052PriceUpdateReqDto reqDto){
        /**
         * 构造请求
         */
        Nft052PriceUpdateReq req = Nft052PriceUpdateReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft052PriceUpdateRespDto respDto = Nft052PriceUpdateRespDto.getNew();
        try{
            Nft052PriceUpdateResp resp = zxlnftSdkService.nft052PriceUpdate(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft053PriceUpdateResultRespDto> nft053PriceUpdateResult(Nft053PriceUpdateResultReqDto reqDto){
        /**
         * 构造请求
         */
        Nft053PriceUpdateResultReq req = Nft053PriceUpdateResultReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft053PriceUpdateResultRespDto respDto = Nft053PriceUpdateResultRespDto.getNew();
        try{
            Nft053PriceUpdateResultResp resp = zxlnftSdkService.nft053PriceUpdateResult(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }

    public ZxlnftResponseDto<Nft054QueryUserAddressBelongToUserRespDto> nft054QueryUserAddressBelongToUser(Nft054QueryUserAddressBelongToUserReqDto reqDto){
        /**
         * 构造请求
         */
        Nft054QueryUserAddressBelongToUserReq req = Nft054QueryUserAddressBelongToUserReq.getNew();
        BeanUtil.copy(reqDto,req);

        Nft054QueryUserAddressBelongToUserRespDto respDto = Nft054QueryUserAddressBelongToUserRespDto.getNew();
        try{
            Nft054QueryUserAddressBelongToUserResp resp = zxlnftSdkService.nft054QueryUserAddressBelongToUser(req);
            BeanUtil.copy(resp,respDto);
        }catch(ZxlNftException e){
            return ZxlnftResponseDto.failure(e.getCode()+","+e.getMessage());
        }
        return ZxlnftResponseDto.success(respDto);
    }
}
