
package com.liquidnet.service.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * 业务类型
 * @author <a href="mailto:kowlone2006@163.com">An Jiabin</a>
 * @version 1.0 2017年9月6日 下午3:53:10
 */
public enum BizType {
    /** 登录绑定 */
	BIND_LOGIN(1),
	/** 绑定手机号 */
	BIND_PHONENUMBER(2),
	/** 实名认证 */
	BIND_IDCARD(3),
	/** 绑卡银行卡*/
	BIND_BANKCARD(4),
	/** 语音认证*/
	BIND_VOICE(5),
	/** 信审*/
	CREDIT_ADUIT(6),
	/**充值 */
    RECHARGE(7),
	/** 提现*/
    WITHDRAW(8),
	/** 还款*/
    REPAYMENT(9),
	/** 借款*/
    BORROW_MONEY(10),
    /** 借款*/
    TEMP_CREDITAMOUNT(11),
	/** 延期还款*/
	POSTPONE_REPAYMENT(901),
	;

	private final int type;

	BizType(int type) {
		this.type = type;
	}

	public int getType() {
		return type;
	}
    public int getValue() {
        return type;
    }
    private static Map<Integer, BizType> cache = new HashMap<>();

    static{
        for (BizType activityCode : BizType.values()) {
            cache.put(activityCode.getValue(), activityCode);
        }
    }

    /**
     * <p>get.</p>
     *
     * @param value a int.
     * @return a {@link BizType} object.
     */
    public static BizType get(int value) {
        return cache.get(value);
    }

    public static BizType getActivityCode(int value) {
        for (BizType activityCode : BizType.values()) {
            if (value == activityCode.getValue()) {
                return activityCode;
            }
        }
        return null;
    }
}
