package com.liquidnet.client.admin.common.enums;

import org.apache.ibatis.annotations.ResultType;

import java.util.*;

/**
 * <p>
 * banner跳转类型
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-08 11:23 上午
 */
public enum BannersTargetType {

    TARGET_TYPE1("PGC点播", 1),
    TARGET_TYPE2("PGC直播", 2),
    TARGET_TYPE5("场地", 5),
    TARGET_TYPE6("票务", 6),
    TARGET_TYPE7("商品", 7),
    TARGET_TYPE8("巡演", 8),
    TARGET_TYPE12("活动跳转-可分享", 12),
    TARGET_TYPE100("活动跳转", 100),
    TARGET_TYPE13("积分商品", 13),
    TARGET_TYPE14("商品集合", 14),
    TARGET_TYPE20("音乐人", 20),
    TARGET_TYPE21("歌曲", 21),
    TARGET_TYPE22("专辑", 22),
    TARGET_TYPE23("视频播单", 23),
    TARGET_TYPE24("音乐人集合", 24),
    TARGET_TYPE26("摩登会员", 26),
    TARGET_TYPE201("youngBlood报名跳转", 201),
    TARGET_TYPE0("不跳转", 0);

    private String name;
    private int index;

    BannersTargetType(String name, int index) {
        this.name = name;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    private static List<Object> resultTypeListR = null;

    static {
        ArrayList<Object> resultTypeList = new ArrayList<>();
        for (BannersTargetType resultType : BannersTargetType.values()) {
            Map<String, Object> mapTemp = new HashMap<>();
            mapTemp.put("id", resultType.index);
            mapTemp.put("name", resultType.name);
            resultTypeList.add(mapTemp);
        }
        resultTypeListR = Collections.unmodifiableList(resultTypeList);
    }

    public static List<Object> getResultType() {
        return resultTypeListR;
    }

    public static String getTypeName(int index) {
        for (BannersTargetType c : BannersTargetType.values()) {
            if (c.getIndex() == index) {
                return c.name;
            }
        }
        return null;
    }
}
