package com.liquidnet.service.consumer.slowly.config;

import com.liquidnet.common.cache.redis.config.RedisStreamConfig;
import com.liquidnet.service.base.constant.MQConst;
import com.liquidnet.service.consumer.slowly.receiver.ConsumerGoblinStoreMarketRdsReceiver;
import lombok.var;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.data.redis.stream.Subscription;

@Configuration
public class ConsumerGoblinStoneMarketRedisStreamConfig extends RedisStreamConfig {
    @Autowired
    ConsumerGoblinStoreMarketRdsReceiver consumerGoblinStoreMarketRdsReceiver;

    /**
     * 缺票登记
     *
     * @param listenerContainer
     * @param t
     * @return
     */
    private Subscription receiveGoblinStoreMarket(StreamMessageListenerContainer<String, MapRecord<String, String, String>> listenerContainer, int t) {
        return listenerContainer.receiveAutoAck(Consumer.from(MQConst.GoblinQueue.GOBLIN_STORE_MARKET.getGroup(), getConsumerName(MQConst.GoblinQueue.GOBLIN_STORE_MARKET.name() + t)),
                StreamOffset.create(MQConst.GoblinQueue.GOBLIN_STORE_MARKET.getKey(), ReadOffset.lastConsumed()), consumerGoblinStoreMarketRdsReceiver);
    }

    /* —————————————————————————— ｜ —————————————————————————— ｜ —————————————————————————— */

    /* -------------------------------------------------------- ｜ 缺票登记 */

    @Bean
    public Subscription subscriptionGoblinStoreMarket0(RedisConnectionFactory factory) {
        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
        var subscription = receiveGoblinStoreMarket(listenerContainer, 0);
        listenerContainer.start();
        return subscription;
    }

//    @Bean
//    public Subscription subscriptionGoblinStoreMarket1(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveGoblinStoreMarket(listenerContainer, 1);
//        listenerContainer.start();
//        return subscription;
//    }
//
//    @Bean
//    public Subscription subscriptionGoblinStoreMarket2(RedisConnectionFactory factory) {
//        var listenerContainer = this.buildStreamMessageListenerContainer(factory);
//        var subscription = receiveGoblinStoreMarket(listenerContainer, 2);
//        listenerContainer.start();
//        return subscription;
//    }

    /* -------------------------------------------------------- ｜  */
}
