package com.liquidnet.service.platform.controller.express.shunfeng;

import com.liquidnet.service.base.ErrorMapping;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.kylin.dto.param.PerformanceExpressPushFreightParam;
import com.liquidnet.service.kylin.dto.param.PerformanceExpressPushRouteParam;
import com.liquidnet.service.kylin.dto.param.PerformanceExpressPushStatusParam;
import com.liquidnet.service.kylin.dto.vo.express.KylinOrderExpressRouteVo;
import com.liquidnet.service.platform.service.express.shunfeng.PerformancesExpressCallbackServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;

/**
 * <p>
 * 演出快递 顺丰推送
 * </p>
 *
 * @author jiangxiulong
 * @since 2021-06-29
 */

@Api(tags = "前端-shunfengCallBack")
@RestController
@RequestMapping("performancesExpress")
public class PerformancesExpressCallbackController {

    @Autowired
    private PerformancesExpressCallbackServiceImpl performancesExpressServiceImpl;

    @PostMapping("orderRoute")
    @ApiOperation("路由推送")
    public HashMap listOrderRoute(@RequestBody String performanceExpressPushRouteParam) {
        boolean result = performancesExpressServiceImpl.orderRoute(performanceExpressPushRouteParam);
        HashMap<Object, Object> objectObjectHashMap = new HashMap<>();
        if (result) {
            objectObjectHashMap.put("status", "OK");
        } else {
            objectObjectHashMap.put("status", "ERR");
        }
        return objectObjectHashMap;
    }

    @PostMapping("orderStatus")
    @ApiOperation("订单状态推送") // 暂时业务不需要 这个是收件的状态
    public HashMap OrderStatus(@RequestBody String performanceExpressPushStatusParam) {
        boolean result = performancesExpressServiceImpl.orderStatus(performanceExpressPushStatusParam);
        HashMap<Object, Object> objectObjectHashMap = new HashMap<>();
        if (result) {
            objectObjectHashMap.put("status", "OK");
        } else {
            objectObjectHashMap.put("status", "ERR");
        }
        return objectObjectHashMap;
    }

    @PostMapping("orderFreightList")
    @ApiOperation("清单运费推送") // 暂时业务不需要
    public HashMap getListFreight(@RequestBody String performanceExpressPushFreightParam) {
        boolean result = performancesExpressServiceImpl.orderFreightList(performanceExpressPushFreightParam);
        HashMap<Object, Object> objectObjectHashMap = new HashMap<>();
        if (result) {
            objectObjectHashMap.put("status", "OK");
        } else {
            objectObjectHashMap.put("status", "ERR");
        }
        return objectObjectHashMap;
    }

    @GetMapping("orderRoute/{orderTicketsId}")
    @ApiOperation("获取物流信息") // 前端使用
    @ApiImplicitParam(name = "orderTicketsId", value = "订单ID", required = true, dataType = "String", paramType = "path")
    public ResponseDto<List<KylinOrderExpressRouteVo>> orderRouteDetail(@PathVariable() String orderTicketsId) {
        List<KylinOrderExpressRouteVo> routeVoList = performancesExpressServiceImpl.orderRouteDetail(orderTicketsId);
        if (null != routeVoList) {
            return ResponseDto.success(routeVoList);
        } else {
            return ResponseDto.failure(ErrorMapping.get("20800"));
        }
    }

}
