package com.liquidnet.client.admin.zhengzai.kylin.dto;

import com.liquidnet.client.admin.common.annotation.Excel;
import com.liquidnet.service.kylin.dao.MemberOrderExportDao;
import lombok.Data;

import java.io.Serializable;

@Data
public class OrderMemberExportVo implements Serializable, Cloneable {

    @Excel(name = "商户订单号", cellType = Excel.ColumnType.STRING)
    private String payCode;
    @Excel(name = "微信/支付宝订单号", cellType = Excel.ColumnType.STRING)
    private String paymentId;
    @Excel(name = "支付方式", cellType = Excel.ColumnType.STRING)
    private String payType;
    @Excel(name = "订单状态", cellType = Excel.ColumnType.STRING)
    private String state;
    @Excel(name = "价格", cellType = Excel.ColumnType.STRING)
    private String price;
    @Excel(name = "支付时间", cellType = Excel.ColumnType.STRING)
    private String paymentAt;
    @Excel(name = "创建时间", cellType = Excel.ColumnType.STRING)
    private String createdAt;
    @Excel(name = "更新时间", cellType = Excel.ColumnType.STRING)
    private String updatedAt;
    @Excel(name = "退款时间", cellType = Excel.ColumnType.STRING)
    private String refundAt;
    @Excel(name = "退款金额", cellType = Excel.ColumnType.STRING)
    private String refundPrice;

    private static final OrderMemberExportVo obj = new OrderMemberExportVo();

    public static OrderMemberExportVo getNew() {
        try {
            return (OrderMemberExportVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return new OrderMemberExportVo();
    }

    public OrderMemberExportVo copyMemberOrderExportVo(MemberOrderExportDao source) {
        this.setPayCode(source.getPayNo());
        this.setPaymentId(source.getPaymentId());
        this.setPayType(source.getPayType());
        this.setState(source.getState());
        this.setPrice(source.getPrice());
        this.setPaymentAt(source.getPaymentAt());
        this.setCreatedAt(source.getCreatedAt());
        this.setUpdatedAt(source.getUpdatedAt());
        this.setRefundAt(source.getRefundAt());
        this.setRefundPrice(source.getRefundPrice());
        return this;
    }

}
