package com.liquidnet.service.goblin.dto.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.liquidnet.commons.lang.util.DateUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

@ApiModel(value = "GoblinNftGoodsInfoListVo", description = "NFT商品SPU详情[不包含具体SKU，SKU详情参见'GoblinNftGoodsSkuInfoVo']")
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class GoblinNftGoodsInfoListVo implements Serializable, Cloneable {

    private static final long serialVersionUID = -3869909399504844722L;

    @ApiModelProperty(position = 10, value = "店铺ID")
    private String storeId;
    @ApiModelProperty(position = 11, value = "商品ID[64]")
    private String spuId;
    @ApiModelProperty(position = 12, value = "商品编码[默认为系统编码，也可手动输入商家自己的编码]")
    private String spuNo;
    @ApiModelProperty(position = 13, value = "商品名称[100]")
    private String name;
    @ApiModelProperty(position = 14, value = "商品副标题[128]")
    private String subtitle;
    @ApiModelProperty(position = 20, value = "封面图片地址[256]")
    private String coverPic;
    @ApiModelProperty(position = 21, value = "商品视频地址")
    private String video;

    @ApiModelProperty(position = 15, value = "销售价-原价[20,2]")
    private BigDecimal sellPrice;
    @ApiModelProperty(position = 16, value = "价格区间MIN[20,2]")
    private BigDecimal priceGe;
    @ApiModelProperty(position = 17, value = "价格区间MAX[20,2]")
    private BigDecimal priceLe;

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 31, value = "开售时间")
    private LocalDateTime saleStartTime;
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    @ApiModelProperty(position = 31, value = "停售时间")
    private LocalDateTime saleStopTime;
    @ApiModelProperty(position = 32, value = "商品有效期[YYYY-MM-DD]")
    private String spuValidity;

    @ApiModelProperty(position = 34, value = "审核状态[0-编辑中|1-审核中|2-审核不通过|3-审核通过]")
    private String status;
    @ApiModelProperty(position = 36, value = "商品上架状态[0-待上架|1-下架|2-违规|3-上架]")
    private String shelvesStatus;
    @ApiModelProperty(position = 37, value = "自定义展示[0-默认展示|1-隐藏不可购买]")
    private String spuAppear;

    @ApiModelProperty(position = 37, value = "创作者")
    private String author;
    @ApiModelProperty(position = 37, value = "发行方")
    private String publisher;

    @ApiModelProperty(position = 39, value = "上架时间")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DateUtil.DATE_FULL_STR)
    private LocalDateTime shelvesAt;

    @ApiModelProperty(position = 40, value = "商品图片列表")
    private List<String> imageList;

    @ApiModelProperty(position = 52, value = "商品标签列表")
    private List<GoblinGoodsTagVo> tagVoList;
    @ApiModelProperty(position = 54, value = "音乐人、艺术家、IP列表")
    private List<GoblinGoodsExtagVo> extagVoList;
    @ApiModelProperty(position = 55, value = "AR标签")
    private List<GoblinGoodsExtagVo> artagVoList;

    @ApiModelProperty(position = 56, value = "SPU包含的SKU_ID列表")
    private List<String> skuIdList;

    @ApiModelProperty(position = 61, value = "销量")
    private Integer count;
    @ApiModelProperty(position = 62, value = "商铺名称")
    private String storeName;

    @ApiModelProperty(position = 63, value = "skuList")
    private List<GoblinNftGoodsSkuInfoVo> nftGoodsSkuInfoVoList;

    private static final GoblinNftGoodsInfoListVo obj = new GoblinNftGoodsInfoListVo();

    public static GoblinNftGoodsInfoListVo getNew() {
        try {
            return (GoblinNftGoodsInfoListVo) obj.clone();
        } catch (CloneNotSupportedException e) {
            return new GoblinNftGoodsInfoListVo();
        }
    }

}
