package com.liquidnet.service.goblin.service.impl;

import com.github.pagehelper.PageInfo;
import com.liquidnet.commons.lang.util.CurrentUtil;
import com.liquidnet.service.base.ResponseDto;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinGoodsSkuInfoVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftGoodsInfoListVo;
import com.liquidnet.service.goblin.dto.vo.GoblinNftGoodsSkuInfoVo;
import com.liquidnet.service.goblin.service.GoblinCouponService;
import com.liquidnet.service.goblin.service.IGoblinNftGoodsAppService;
import com.liquidnet.service.goblin.util.GoblinMongoUtils;
import com.liquidnet.service.goblin.util.GoblinRedisUtils;
import com.liquidnet.service.goblin.util.QueueUtils;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
@Slf4j
public class GoblinNftGoodsAppServiceImpl implements IGoblinNftGoodsAppService {

    @Autowired
    private GoblinRedisUtils goblinRedisUtils;
    @Autowired
    MongoTemplate mongoTemplate;
    @Autowired
    QueueUtils queueUtils;
    @Autowired
    GoblinMongoUtils mongoUtils;
    @Autowired
    GoblinCouponService goblinCouponService;

    @Override
    public ResponseDto<PageInfo<GoblinNftGoodsInfoListVo>> goodsList(int page) {
        int size = 20;
        //条件
        Query query = Query.query(
                Criteria.where("spuType").is(1).and("delFlg").is(0).and("status").is(3).and("shelvesStatus").is(3).and("")
        );
        long count = mongoTemplate.count(query, GoblinGoodsInfoVo.class, GoblinGoodsInfoVo.class.getSimpleName());
        List<GoblinNftGoodsInfoListVo> spuList = goblinRedisUtils.getGoblinNftGoodsInfoListVo();
        if (null == spuList || page > 1) {
            spuList = new ArrayList<>();
            // 排序 分页
            Pageable pageable = PageRequest.of(page - 1, size, Sort.by(Sort.Direction.DESC, "createdAt"));
            query.with(pageable);

            List <GoblinGoodsInfoVo> goodsInfoVoList = mongoTemplate.find(query, GoblinGoodsInfoVo.class, GoblinGoodsInfoVo.class.getSimpleName());
            for (GoblinGoodsInfoVo info : goodsInfoVoList) {
                List<String> skuIdList = info.getSkuIdList();
                List<GoblinNftGoodsSkuInfoVo> spuSkuVoList = new ArrayList<>();
                for (String skuId : skuIdList) {
                    GoblinGoodsSkuInfoVo skuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(skuId);
                    GoblinNftGoodsSkuInfoVo nftGoodsSkuInfoVo = GoblinNftGoodsSkuInfoVo.getNew();
                    BeanUtils.copyProperties(skuInfoVo, nftGoodsSkuInfoVo);
                    spuSkuVoList.add(nftGoodsSkuInfoVo);
                }

                GoblinNftGoodsInfoListVo nftGoodsInfoListVo = GoblinNftGoodsInfoListVo.getNew();
                BeanUtils.copyProperties(info, nftGoodsInfoListVo);
                nftGoodsInfoListVo.setNftGoodsSkuInfoVoList(spuSkuVoList);
                spuList.add(nftGoodsInfoListVo);
            }
            if (page <= 1) {
                goblinRedisUtils.setGoblinNftGoodsInfoListVo(spuList);
            }
        }
        PageInfo<GoblinNftGoodsInfoListVo> pageInfo = new PageInfo(spuList);
        pageInfo.setTotal(count);
        return ResponseDto.success(pageInfo);
    }

    @Override
    public GoblinNftGoodsInfoListVo goodsDetail(String spuId, String skuId) {
        GoblinGoodsInfoVo goodsInfoVo = goblinRedisUtils.getGoodsInfoVo(spuId);
        if (null != goodsInfoVo) {
            Integer buyCount = 0;
            String userId = CurrentUtil.getCurrentUid();
            if (StringUtils.isNotBlank(userId)) {
                buyCount = goblinRedisUtils.getSkuCountByUid(userId, skuId);
            }
            GoblinGoodsSkuInfoVo goodsSkuInfoVo = goblinRedisUtils.getGoodsSkuInfoVo(skuId);
            if (null != goodsSkuInfoVo && goodsSkuInfoVo.getDelFlg().equals("0") && goodsSkuInfoVo.getShelvesStatus().equals("3")) {
                //获取 sku 库存数量
                int stock = goblinRedisUtils.getSkuStock(null, skuId);
                log.info("skuId:{}, 库存数量:{}", skuId, stock);
                if (0 != goodsSkuInfoVo.getBuyLimit()) {
                    buyCount = 0;
                    // TODO: jxl 2022/3/25 新vo处理
//                    goodsSkuInfoVo.setCanBuy(goodsSkuInfoVo.getBuyLimit() - buyCount);
                } else {
//                    goodsSkuInfoVo.setCanBuy(-9999);
                }
                if (stock <= 0) {
//                    goodsSkuInfoVo.setStockLess(true);
                } else {
//                    goodsSkuInfoVo.setStockLess(false);
                }
                List<GoblinGoodsSkuInfoVo> spuSkuVoList = new ArrayList<>();
                spuSkuVoList.add(goodsSkuInfoVo);
                goodsInfoVo.setGoblinOrderSkuVos(spuSkuVoList);
            } else {
                return null;
            }
        } else {
            return null;
        }

//        return goodsInfoVo;
        return GoblinNftGoodsInfoListVo.getNew();
    }

    @Override
    public Boolean exchange(String code) {
        // 验证
        // 使用
        // 下单
        return true;
    }

}
